% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity_alpha.R
\docType{methods}
\name{index_brillouin}
\alias{index_brillouin}
\alias{index_brillouin-method}
\alias{index_brillouin,numeric-method}
\title{Brillouin Diversity Index.}
\usage{
index_brillouin(x, ...)

\S4method{index_brillouin}{numeric}(x, evenness = FALSE, na.rm = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector of count data (absolute frequencies).}

\item{...}{Currently not used.}

\item{evenness}{A \code{\link{numeric}} scalar: should evenness be computed?}

\item{na.rm}{A \code{\link{numeric}} scalar: should missing values (including \code{NaN}) be
removed?}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Brillouin Diversity Index.
}
\details{
The Brillouin index describes a known collection: it does not assume random
sampling in an infinite population. Pielou (1975) and Laxton (1978) argues
for the use of the Brillouin index in all circumstances, especially in
preference to the Shannon index.
}
\note{
Ramanujan approximation is used for \eqn{x!} computation if \eqn{x > 170}.
}
\references{
Brillouin, L. (1956). \emph{Science and information theory}. New York:
Academic Press.

Laxton, R. R. (1978). The measure of diversity. \emph{Journal of Theoretical
Biology}, 70(1), 51-67.
\doi{10.1016/0022-5193(78)90302-8}.

Pielou, E. C. (1975). \emph{Ecological Diversity}. New York: Wiley.
\doi{10.4319/lo.1977.22.1.0174b}
}
\seealso{
Other alpha diversity measures: 
\code{\link{index_ace}()},
\code{\link{index_baxter}()},
\code{\link{index_berger}()},
\code{\link{index_boone}()},
\code{\link{index_chao1}()},
\code{\link{index_chao2}()},
\code{\link{index_hurlbert}()},
\code{\link{index_ice}()},
\code{\link{index_margalef}()},
\code{\link{index_mcintosh}()},
\code{\link{index_menhinick}()},
\code{\link{index_shannon}()},
\code{\link{index_simpson}()},
\code{\link{index_squares}()},
\code{\link{observed}()}
}
\author{
N. Frerebeau
}
\concept{alpha diversity measures}
