% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity.R
\docType{methods}
\name{heterogeneity}
\alias{heterogeneity}
\alias{heterogeneity-method}
\alias{heterogeneity,matrix-method}
\alias{heterogeneity,data.frame-method}
\title{Heterogeneity}
\usage{
heterogeneity(object, ...)

\S4method{heterogeneity}{matrix}(
  object,
  ...,
  method = c("shannon", "simpson", "berger", "boone", "brillouin", "mcintosh")
)

\S4method{heterogeneity}{data.frame}(
  object,
  ...,
  method = c("shannon", "simpson", "berger", "boone", "brillouin", "mcintosh")
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table). A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{...}{Further arguments to be passed to internal methods (see below).}

\item{method}{A \code{\link{character}} string specifying the index to be computed
(see details). Any unambiguous substring can be given.}
}
\value{
An \linkS4class{HeterogeneityIndex} object.
}
\description{
Computes an heterogeneity or a dominance index.
}
\details{
The following heterogeneity index are available (see Magurran 1988 for
details):
\describe{
\item{\code{berger}}{\link[=index_berger]{Berger-Parker dominance index}.}
\item{\code{boone}}{\link[=index_boone]{Boone heterogeneity measure}.}
\item{\code{brillouin}}{\link[=index_brillouin]{Brillouin diversity index}.}
\item{\code{mcintosh}}{\link[=index_mcintosh]{McIntosh dominance index}.}
\item{\code{shannon}}{\link[=index_shannon]{Shannon-Wiener diversity index}.}
\item{\code{simpson}}{\link[=index_simpson]{Simpson dominance index}.}
}

The \code{berger}, \code{mcintosh} and \code{simpson} methods return a \emph{dominance} index,
not the reciprocal or inverse form usually adopted, so that an increase in
the value of the index accompanies a decrease in diversity.
}
\examples{
## Data from Conkey 1980, Kintigh 1989
data("cantabria")

## Alpha diversity
diversity(cantabria)

## Shannon diversity index
(h <- heterogeneity(cantabria, method = "shannon"))
(e <- evenness(cantabria, method = "shannon"))

as.data.frame(h)
}
\references{
Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
Princeton, NJ: Princeton University Press.
\doi{10.1007/978-94-015-7358-0}.
}
\seealso{
\code{\link[=index_berger]{index_berger()}}, \code{\link[=index_boone]{index_boone()}}, \code{\link[=index_brillouin]{index_brillouin()}},
\code{\link[=index_mcintosh]{index_mcintosh()}}, \code{\link[=index_shannon]{index_shannon()}}, \code{\link[=index_simpson]{index_simpson()}}

Other diversity measures: 
\code{\link{diversity}()},
\code{\link{evenness}()},
\code{\link{occurrence}()},
\code{\link{plot.DiversityIndex}()},
\code{\link{plot.RarefactionIndex}()},
\code{\link{profiles}()},
\code{\link{rarefaction}()},
\code{\link{richness}()},
\code{\link{she}()},
\code{\link{similarity}()},
\code{\link{simulate}()},
\code{\link{turnover}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
