% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabularaster-package.R
\name{ghrsst}
\alias{ghrsst}
\alias{sst_regions}
\title{Sea surface temperature data.}
\format{
A raster created GHRSST data and raster smoothing.
}
\description{
A smoothed subset of GHRSST.
}
\details{
See "data-raw/ghrsst.R" and "data-raw/ghrsst-readme.txt" for
details.

\code{sst_regions} is a simple polygon region layer to sit over the SST data.
}
\examples{
\donttest{
library(raster)
plot(ghrsst, col = hcl.colors(12, "YlOrRd", rev = TRUE))
plot(sst_regions, add = TRUE, col = NA)
cellnumbers(ghrsst, sst_regions) 
}
}
