/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import gnu.trove.procedure.TIntProcedure;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jsi.SpatialIndex;
import net.sf.jsi.rtree.RTree;
import technology.tabula.Rectangle;
import technology.tabula.Utils;

class RectangleSpatialIndex<T extends Rectangle> {
    private final SpatialIndex si = new RTree();
    private final List<T> rectangles;
    private Rectangle bounds = null;

    public RectangleSpatialIndex() {
        this.si.init(null);
        this.rectangles = new ArrayList<T>();
    }

    public void add(T te) {
        this.rectangles.add(te);
        if (this.bounds == null) {
            this.bounds = new Rectangle();
            this.bounds.setRect((Rectangle2D)te);
        } else {
            this.bounds.merge((Rectangle)te);
        }
        this.si.add(this.rectangleToSpatialIndexRectangle((Rectangle)te), this.rectangles.size() - 1);
    }

    public List<T> contains(Rectangle r) {
        SaveToListProcedure proc = new SaveToListProcedure();
        this.si.contains(this.rectangleToSpatialIndexRectangle(r), proc);
        ArrayList<T> rv = new ArrayList<T>();
        Iterator iterator = proc.getIds().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            rv.add(this.rectangles.get(i));
        }
        Utils.sort(rv);
        return rv;
    }

    public List<T> intersects(Rectangle r) {
        SaveToListProcedure proc = new SaveToListProcedure();
        this.si.intersects(this.rectangleToSpatialIndexRectangle(r), proc);
        ArrayList<T> rv = new ArrayList<T>();
        Iterator iterator = proc.getIds().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            rv.add(this.rectangles.get(i));
        }
        Utils.sort(rv);
        return rv;
    }

    private net.sf.jsi.Rectangle rectangleToSpatialIndexRectangle(Rectangle r) {
        return new net.sf.jsi.Rectangle((float)r.getX(), (float)r.getY(), (float)(r.getX() + r.getWidth()), (float)(r.getY() + r.getHeight()));
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    class SaveToListProcedure
    implements TIntProcedure {
        private List<Integer> ids = new ArrayList<Integer>();

        SaveToListProcedure() {
        }

        @Override
        public boolean execute(int id) {
            this.ids.add(id);
            return true;
        }

        private List<Integer> getIds() {
            return this.ids;
        }
    }
}

