% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab_plain}
\alias{tab_plain}
\title{Plain single cross-table}
\usage{
tab_plain(
  data,
  row_var,
  col_var,
  tab_vars,
  wt,
  pct = "no",
  color = "no",
  OR = "no",
  na = "keep",
  ref = "auto",
  ref2 = "first",
  comp = "tab",
  totaltab = "line",
  totaltab_name = "Ensemble",
  tot = NULL,
  total_names = "Total",
  subtext = "",
  digits = 0,
  num = FALSE,
  df = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{row_var, col_var}{The row variable, which will be printed with one level per line,
and the column variable, which will be printed with one level per column. Numeric
variables will be used as factors. To calculate means, use \code{\link{tab_num}}.}

\item{tab_vars}{<\link[tidyr:tidyr_tidy_select]{tidy-select}> Tab variables :
a subtable is made for each combination of levels of the
selected variables. Leave empty to make a simple cross-table. All tab variables
are converted to factor.}

\item{wt}{A weight variable, of class numeric. Leave empty for unweighted results.}

\item{pct}{The type of percentages to calculate :
\itemize{
\item \code{"row"}: row percentages.
\item \code{"col"}: column percentages.
\item \code{"all"}: frequencies for each subtable/group, if there is \code{tab_vars}.
\item \code{"all_tabs"}: frequencies for the whole (set of) table(s).
}}

\item{color}{The type of colors to print, as a single string :
\itemize{
\item \code{"no"}: by default, no colors are printed.
\item \code{"diff"}: color percentages and means based on cells differences from
totals (or from first cells when \code{ref = "first"}).
\item \code{"OR"}: for \code{pct == "col"} or \code{pct == "row"},
color based on odds ratios (or relative risks ratios)
}}

\item{OR}{With \code{pct = "row"} or \code{pct = "col"}, calculate and print odds ratios
(for binary variables) or relative risks ratios (for variables with 3 levels
or more).
\itemize{
\item \code{"no"}: by default, no OR are calculated.
\item \code{"OR"}: print OR (instead of percentages).
\item \code{"OR_pct"}: print OR, with percentages in bracket.
}}

\item{na}{The policy to adopt with missing values, as a single string.
\itemize{
\item \code{"keep"}: by default, \code{NA}'s of row, col and tab variables
are printed as explicit "NA" level.
\item \code{"drop"}: removes NA of row, col and tab variables.
}}

\item{ref}{The reference cell to calculate differences and ratios
(used to print \code{colors}) :
\itemize{
\item \code{"auto"}: by default, cell difference from the corresponding total
(rows or cols depending on \code{pct = "row"} or \code{pct = "col"}) is
used for \code{diff} ; cell ratio from the first line (or col) is use for \code{OR}
(odds ratio/relative risks ratio).
\item \code{"tot"}: totals are always used.
\item \code{"first"}: calculate cell difference or ratio from the first cell
of the row or column (useful to color temporal developments).
\item \code{n}: when \code{ref} is an integer, the nth row (or column) is used for comparison.
\item \code{"regex"}: when \code{ref} is a string, it it used as a regular expression,
to match with the names of the rows (or columns). Be precise enough to match only one
column or row, otherwise you get a warning message.
\item \code{"no"}: not use ref and not calculate diffs to gain calculation time.
}}

\item{ref2}{A second reference cell is needed to calculate odds ratios
(or relative risks ratios). The first cell of the row or column is used by default.
See \code{ref} above for the full list of possible values.}

\item{comp}{Comparison level. When \code{tab_vars} are present, should the
contributions to variance be calculated for each subtable/group (by default,
\code{comp = "tab"}) ? Should they be calculated for the whole table
(\code{comp = "all"}) ?
\code{comp} must be set once and for all the first time you use \code{\link{tab_plain}},
\code{\link{tab_num}} or \code{\link{tab_chi2}} with rows, or \code{\link{tab_ci}}.}

\item{totaltab}{The total table,
if there are subtables/groups (i.e. when \code{tab_vars} is provided) :
\itemize{
\item \code{"line"}: by default, add a general total line (necessary for
calculations with \code{comp = "all"})
\item \code{"table"}: add a complete total table
(i.e. \code{row_var} by \code{col_vars} without \code{tab_vars}).
\item \code{"no"}: not to draw any total table.
}}

\item{totaltab_name}{The name of the total table, as a single string.}

\item{tot}{The totals :
\itemize{
\item \code{c("col", "row")} or \code{"both"} : by default, both total rows and total
columns.
\item \code{"row"}: only total rows.
\item \code{"col"}: only total column.
\item \code{"no"}: remove all totals (after calculations if needed).
}}

\item{total_names}{The names of the totals, as a character vector of length one or two.
Use syntax of type \code{c("Total row", "Total column")} to set different names for
rows and cols.}

\item{subtext}{A character vector to print rows of legend under the table.}

\item{digits}{The number of digits to print, as a single integer.}

\item{num}{Set to \code{TRUE} to obtain a table with normal numeric vectors (not fmt).}

\item{df}{Set to \code{TRUE} to obtain a plain data.frame (not a tibble),
with normal numeric vectors (not fmt). Useful, for example, to pass the table to
correspondence analysis with \pkg{FactoMineR}.}
}
\value{
A \code{tibble} of class \code{tabxplor_tab}. If \code{...} (\code{tab_vars})
are provided, a \code{tab} of class \code{tabxplor_grouped_tab}.
All non-text columns are \code{\link{fmt}} vectors of class \code{tabxplor_fmt},
storing all the data necessary to print formats and colors. Columns with \code{row_var}
and \code{tab_vars} are of class \code{factor} : every added \code{factor} will be
considered as a \code{tab_vars} and used for grouping. To add text columns without
using them in calculations, be sure they are of class \code{character}.
}
\description{
Plain single cross-table
}
\examples{
# A typical workflow with tabxplor step-by-step functions :
\donttest{
data <- dplyr::starwars \%>\% tab_prepare(sex, hair_color)

data \%>\%
  tab_plain(sex, hair_color, tot = c("row", "col"), pct = "row") \%>\%
  tab_chi2() \%>\%
  tab_ci(color = "after_ci")
}
}
