tar_test("tar_unscript()", {
  dir.create(path_script_r(path_script_default()))
  tar_unscript()
  expect_true(file.exists(path_script_r(path_script_default())))
  file.create("_targets.R")
  tar_unscript()
  expect_false(file.exists(path_script_r(path_script_default())))
})

tar_test("custom script and store args", {
  skip_cran()
  expect_equal(tar_config_get("script"), path_script_default())
  expect_equal(tar_config_get("store"), path_store_default())
  tar_script({
    tar_option_set(workspace_on_error = TRUE)
    list(tar_target(x, "value"), tar_target(y, stop(x)))
  }, script = "example/script.R")
  expect_false(file.exists("example/store/workspaces/y"))
  try(
    tar_make(
      callr_function = NULL,
      script = "example/script.R",
      store = "example/store"
    ),
    silent = TRUE
  )
  dir_create("example/script_r")
  file.create("example/script_r/helper.R")
  expect_true(file.exists("example/store"))
  expect_true(file.exists("example/script.R"))
  expect_true(file.exists("example/script_r"))
  expect_true(file.exists("example/script_r/helper.R"))
  tar_unscript(script = "example/script.R")
  expect_true(file.exists("example/store"))
  expect_true(file.exists("example/script.R"))
  expect_false(file.exists("example/script_r"))
  expect_false(file.exists("example/script_r/helper.R"))
  expect_false(file.exists("_targets.yaml"))
  expect_equal(tar_config_get("script"), path_script_default())
  expect_equal(tar_config_get("store"), path_store_default())
  expect_false(file.exists(path_script_default()))
  expect_false(file.exists(path_store_default()))
  tar_config_set(script = "x")
  expect_equal(tar_config_get("script"), "x")
  expect_true(file.exists("_targets.yaml"))
})

tar_test("custom script and store args without running the pipeline", {
  skip_cran()
  dir_create("_targets_r")
  expect_equal(tar_config_get("script"), path_script_default())
  expect_equal(tar_config_get("store"), path_store_default())
  tar_script({
    tar_option_set(workspace_on_error = TRUE)
    list(tar_target(x, "value"), tar_target(y, stop(x)))
  }, script = "example/script.R")
  expect_false(file.exists("example/store/workspaces/y"))
  dir_create("example/script_r")
  file.create("example/script_r/helper.R")
  expect_true(file.exists("example/script.R"))
  expect_true(file.exists("example/script_r"))
  expect_true(file.exists("example/script_r/helper.R"))
  tar_unscript(script = "example/script.R")
  expect_true(file.exists("_targets_r"))
  expect_true(file.exists("example/script.R"))
  expect_false(file.exists("example/script_r"))
  expect_false(file.exists("example/script_r/helper.R"))
  expect_false(file.exists("_targets.yaml"))
  expect_equal(tar_config_get("script"), path_script_default())
  expect_equal(tar_config_get("store"), path_store_default())
  expect_false(file.exists(path_script_default()))
  expect_false(file.exists(path_store_default()))
  tar_config_set(script = "x")
  expect_equal(tar_config_get("script"), "x")
  expect_true(file.exists("_targets.yaml"))
})
