% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sanitize_excel_sheet_names}
\alias{sanitize_excel_sheet_names}
\title{Sanitize excel sheet names}
\usage{
sanitize_excel_sheet_names(x, replace = "_")
}
\arguments{
\item{x}{a vector (or anything that can be coerced to one via
\code{\link[=as.character]{as.character()}}).}

\item{replace}{a scalar character to replace illegal characters with}
}
\value{
a character vector of valid excel sheet names
}
\description{
Convert a vector to valid excel sheet names by:
\itemize{
\item trimming names down to 31 characters,
\item ensuring each element of the vector is unique, and
\item removing the illegal characters \code{\ / * [ ] : ?}
}

[ ]: R:%20
}
\examples{

sanitize_excel_sheet_names(
  c("a very: long : vector? containing some illegal characters",
    "a very: long : vector? containing some illegal characters")
)

  # [1] "a very_ long  vector_ containi0" "a very_ long  vector_ containi1"
}
