% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{roots}
\alias{roots}
\title{Get root taxa}
\arguments{
\item{obj}{The \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object containing taxon
information to be queried.}

\item{subset}{(\code{character}) Taxon IDs for which root taxa will be
returned. Default: All taxon in \code{obj} will be used.}

\item{value}{What data to return. This is usually the name of column in a
table in \code{obj$data}. Any result of \code{all_names(obj)} can be used, but it
usually only makes sense to data that corresponds to taxa 1:1, such as
\code{\link[=taxon_ranks]{taxon_ranks()}}. By default, taxon indexes are returned.}
}
\value{
\code{character}
}
\description{
Return the root taxa for a \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object. Can also be used to
get the roots of a subset of taxa.
\preformatted{
obj$roots(subset = NULL, value = NULL)
roots(obj, subset = NULL, value = NULL)}
}
\examples{
# Return indexes of root taxa
roots(ex_taxmap)

# Return indexes for a subset of taxa
roots(ex_taxmap, subset = 2:17)

# Return something besides taxon indexes
roots(ex_taxmap, value = "taxon_names")

}
\seealso{
Other taxonomy indexing functions: \code{\link{leaves}},
  \code{\link{stems}}, \code{\link{subtaxa}},
  \code{\link{supertaxa}}
}
