% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{is_internode}
\alias{is_internode}
\title{Check if taxa are internodes}
\usage{
is_internode(x)
}
\arguments{
\item{x}{The object to get internodes for, such as a \link{taxonomy} object.}
}
\description{
Check if each taxon is an internode. An internode is a taxon with exactly one
supertaxon and one subtaxon. These taxa can be removed without losing
information on the relationships of the remaining taxa.
}
\examples{
x <- taxonomy(c('Carnivora', 'Felidae', 'Panthera', 'Panthera leo',
                'Panthera tigris', 'Ursidae', 'Ursus', 'Ursus arctos'),
              supertaxa = c(NA, 1, 2, 3, 3, 1, 6, 7))
is_internode(x)

}
\seealso{
Other internode functions: 
\code{\link{internodes}()}
}
\concept{internode functions}
