% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bold_search}
\alias{bold_search}
\title{Search Barcode of Life for taxonomic IDs}
\usage{
bold_search(name = NULL, id = NULL, fuzzy = FALSE, dataTypes = "basic",
  includeTree = FALSE, response = FALSE, ...)
}
\arguments{
\item{name}{(character) One or more scientific names.}

\item{id}{(integer) One or more BOLD taxonomic identifiers.}

\item{fuzzy}{(logical) Whether to use fuzzy search or not (default: FALSE).}

\item{dataTypes}{(character) Specifies the datatypes that will be returned. See Details for
options.}

\item{includeTree}{(logical) If TRUE (default: FALSE), returns a list containing information
for parent taxa as well as the specified taxon.}

\item{response}{(logical) Note that response is the object that returns from the Curl call,
useful for debugging, and getting detailed info on the API call.}

\item{...}{Further args passed on to httr::GET, main purpose being curl debugging}
}
\value{
A list of data.frame's.
}
\description{
Search Barcode of Life for taxonomic IDs
}
\details{
You must provide one of name or id. The other parameters are optional.

Options for \code{dataTypes} parameter:

\itemize{
 \item all returns all data
 \item basic returns basic taxon information
 \item images returns specimen image. Includes copyright information, image URL, image metadata.
 \item stats Returns specimen and sequence statistics. Includes public species count, public BIN
 count, public marker counts, public record count, specimen count, sequenced specimen count,
 barcode specimen count, species count, barcode species count.
 \item geo Returns collection site information. Includes country, collection site map.
 \item sequencinglabs Returns sequencing labs. Includes lab name, record count.
 \item depository Returns specimen depositories. Includes depository name, record count.
 \item thirdparty Returns information from third parties. Includes wikipedia summary, wikipedia
 URL, GBIF map.
}
}
\examples{
\donttest{
# A basic example
bold_search(name="Apis")
bold_search(name="Agapostemon")
bold_search(name="Poa")

# Fuzzy search
head(bold_search(name="Po", fuzzy=TRUE))
head(bold_search(name="Aga", fuzzy=TRUE))

# Many names
bold_search(name=c("Apis","Puma concolor"))
nms <- names_list('species')
bold_search(name=nms)

# An example where there is no data
bold_search(id=88899)
}
}
\references{
\url{http://www.boldsystems.org/index.php/resources/api}
}

