% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ids.R
\name{get_ids}
\alias{get_ids}
\alias{get_ids_}
\title{Retrieve taxonomic identifiers for a given taxon name.}
\usage{
get_ids(names, db = c("itis", "ncbi", "eol", "col", "tropicos", "gbif",
  "nbn"), ...)

get_ids_(names, db = c("itis", "ncbi", "eol", "col", "tropicos", "gbif",
  "nbn"), rows = NA, ...)
}
\arguments{
\item{names}{character; Taxonomic name to query.}

\item{db}{character; database to query. One or  more of \code{ncbi}, \code{itis},
\code{eol}, \code{col}, \code{tropicos}, \code{gbif}, or \code{nbn}. By
default db is set to search all data sources. Note that each taxonomic data
source has their own identifiers, so that if you vide the wrong \code{db} value
for the identifier you could get a result, it will likely be wrong (not what
you were expecting).}

\item{...}{Other arguments passed to \code{\link[taxize]{get_tsn}},
\code{\link[taxize]{get_uid}}, \code{\link[taxize]{get_eolid}},
\code{\link[taxize]{get_colid}}, \code{\link[taxize]{get_tpsid}},
\code{\link[taxize]{get_gbifid}},  \code{\link[taxize]{get_nbnid}}.}

\item{rows}{numeric; Any number from 1 to infinity. If the default NA, all rows are returned.
When used in \code{get_ids} this function still only gives back a ids class object with one to
many identifiers. See \code{get_ids_} to get back all, or a subset, of the raw data that you are
presented during the ask process.}
}
\value{
A vector of taxonomic identifiers, each retaining their respective S3
   classes so that each element can be passed on to another function (see e.g.'s).
}
\description{
This is a convenience function to get identifiers across all data sources. You can
use other \code{get_*} functions to get identifiers from specific sources if
you like.
}
\note{
There is a timeout of 1/3 seconds between queries to NCBI.
}
\section{Authentication}{

See \code{\link{taxize-authentication}} for help on authentication
}

\examples{
\dontrun{
# Plug in taxon names directly
## By default you get ids for all data sources
get_ids(names="Chironomus riparius")

# specify rows to limit choices available
get_ids(names="Poa annua", db=c("col","eol"), rows=1)
get_ids(names="Poa annua", db=c("col","eol"), rows=1:2)

## Or you can specify which source you want via the db parameter
get_ids(names="Chironomus riparius", db = 'ncbi')
get_ids(names="Salvelinus fontinalis", db = 'nbn')

get_ids(names=c("Chironomus riparius", "Pinus contorta"), db = 'ncbi')
get_ids(names=c("Chironomus riparius", "Pinus contorta"), db = c('ncbi','itis'))
get_ids(names=c("Chironomus riparius", "Pinus contorta"), db = c('ncbi','itis','col'))
get_ids(names="Pinus contorta", db = c('ncbi','itis','col','eol','tropicos'))
get_ids(names="ava avvva", db = c('ncbi','itis','col','eol','tropicos'))

# Pass on to other functions
out <- get_ids(names="Pinus contorta", db = c('ncbi','itis','col','eol','tropicos'))
classification(out$itis)
synonyms(out$tropicos)

# Get all data back
get_ids_(c("Chironomus riparius", "Pinus contorta"), db = 'nbn', rows=1:10)
get_ids_(c("Chironomus riparius", "Pinus contorta"), db = c('nbn','gbif'), rows=1:10)

# use curl options
get_ids("Agapostemon", db = "ncbi", verbose = TRUE)
}
}
\seealso{
\code{\link[taxize]{classification}}

Other taxonomic-ids: \code{\link{get_boldid}},
  \code{\link{get_colid}}, \code{\link{get_eolid}},
  \code{\link{get_gbifid}}, \code{\link{get_iucn}},
  \code{\link{get_natservid}}, \code{\link{get_nbnid}},
  \code{\link{get_tolid}}, \code{\link{get_tpsid}},
  \code{\link{get_tsn}}, \code{\link{get_uid}},
  \code{\link{get_wiki}}, \code{\link{get_wormsid}}
}
