% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pow.R
\name{get_pow}
\alias{get_pow}
\alias{as.pow}
\alias{as.pow.pow}
\alias{as.pow.character}
\alias{as.pow.list}
\alias{as.pow.data.frame}
\alias{as.data.frame.pow}
\alias{get_pow_}
\title{Get Kew's Plants of the World code for a taxon}
\usage{
get_pow(x, accepted = FALSE, ask = TRUE, messages = TRUE,
  rows = NA, family_filter = NULL, rank_filter = NULL, ...)

as.pow(x, check = TRUE)

\method{as.pow}{pow}(x, check = TRUE)

\method{as.pow}{character}(x, check = TRUE)

\method{as.pow}{list}(x, check = TRUE)

\method{as.pow}{data.frame}(x, check = TRUE)

\method{as.data.frame}{pow}(x, ...)

get_pow_(x, messages = TRUE, rows = NA, ...)
}
\arguments{
\item{x}{character; A vector of common or scientific names}

\item{accepted}{logical; If TRUE, removes names that are not accepted
valid names by ITIS. Set to \code{FALSE} (default) to give back both
accepted and unaccepted names.}

\item{ask}{logical; should \code{get_pow} be run in interactive mode?
If TRUE and more than one pow is found for teh species, the user is
asked for input. If FALSE NA is returned for multiple matches.}

\item{messages}{logical; should progress be printed?}

\item{rows}{numeric; Any number from 1 to infinity. If the default NA,
all rows are considered. Note that this function still only gives back
a pow class object with one to many identifiers. See
\code{\link[=get_pow_]{get_pow_()}} to get back all, or a subset,
of the raw data that you are presented during the ask process.}

\item{family_filter}{(character) A division (aka phylum) name to filter
data after retrieved from NCBI. Optional. See \code{Filtering} below.}

\item{rank_filter}{(character) A taxonomic rank name to filter data after
retrieved from NCBI. See \code{\link[=rank_ref]{rank_ref()}} for possible options.
Though note that some data sources use atypical ranks, so inspect the data
itself for options. Optional. See \code{Filtering} below.}

\item{...}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}

\item{check}{logical; Check if ID matches any existing on the DB, only
used in \code{\link[=as.pow]{as.pow()}}}
}
\value{
A vector of taxonomic identifiers as an S3 class.
If a taxon is not found an \code{NA} is given. If more than one identifier
is found the function asks for user input if \code{ask = TRUE}, otherwise
returns \code{NA}. If \code{ask=FALSE} and \code{rows} does not equal
\code{NA}, then a data.frame is given back, but not of the uid class, which
you can't pass on to other functions as you normally can.

See \code{\link{get_id_details}} for further details including
attributes and exceptions
}
\description{
Get Kew's Plants of the World code for a taxon
}
\section{Filtering}{

The parameters \code{family_filter} an\code{rank_filter}er are not
used in the search to the data provider, but are used in filtering the data down to a
subset that is closer to the target you want.  For these two parameters,
you can use regex strings since we use \code{\link[=grep]{grep()}} internally to match.
Filtering narrows down to the set that matches your query, and removes the rest.
}

\examples{
\dontrun{
get_pow(x = "Helianthus")
get_pow(c("Helianthus","Quercus douglasii"))

# Get back a subset
get_pow(x="Helianthus", rows = 1)
get_pow(x="Helianthus", rows = 1:10)

# When not found
get_pow("howdy")
get_pow(c("Helianthus annuus", "howdy"))

# Narrow down results 
# to accepted names
get_pow("Helianthus", accepted = TRUE)
# to a kingom 
get_pow("Helianthus", rank_filter = "genus")
# to accepted names and rank
get_pow("Helianthus annuus", accepted = TRUE, rank_filter = "species")
# to a family
get_pow("flower", family_filter = "Acanthaceae")

# Convert a pow without class information to a pow class
z <- get_pow("Helianthus annuus", accepted = TRUE, rank_filter = "species")
# already a pow, returns the same
as.pow(z)
as.pow("urn:lsid:ipni.org:names:119003-2")
# character vector, length > 1
ids <- c("urn:lsid:ipni.org:names:119003-2","urn:lsid:ipni.org:names:328247-2")
as.pow(ids)
# list, with character strings
as.pow(as.list(ids)) 
## dont check, much faster
as.pow("urn:lsid:ipni.org:names:119003-2", check=FALSE)
as.pow(ids, check=FALSE)
as.pow(as.list(ids), check=FALSE)

(out <- as.pow(ids))
data.frame(out)
as.pow( data.frame(out) )

# Get all data back
get_pow_("Quercus", rows=1:5)
get_pow_("Quercus", rows=1)
get_pow_(c("Pinus", "Abies"), rows = 1:3)
}
}
\seealso{
\code{\link[=classification]{classification()}}

Other pow: \code{\link{pow_lookup}},
  \code{\link{pow_search}}

Other taxonomic-ids: \code{\link{get_boldid}},
  \code{\link{get_colid}}, \code{\link{get_eolid}},
  \code{\link{get_gbifid}}, \code{\link{get_ids}},
  \code{\link{get_iucn}}, \code{\link{get_natservid}},
  \code{\link{get_nbnid}}, \code{\link{get_tolid}},
  \code{\link{get_tpsid}}, \code{\link{get_tsn}},
  \code{\link{get_uid}}, \code{\link{get_wiki}},
  \code{\link{get_wormsid}}
}
\concept{pow}
\concept{taxonomic-ids}
