% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_methods.R
\name{get_inconsistencies}
\alias{get_inconsistencies}
\title{Detect candidate inconsistencies and ambiguity}
\usage{
get_inconsistencies(x, uninomials = TRUE)
}
\arguments{
\item{x}{A list consisting of tibble(s) that have been passed to get_validated()}

\item{uninomials}{A Boolean indicating whether uninomials should be included in the detection (defaults to TRUE)}
}
\value{
A character vector containing scientific names that exhibit inconsistency or ambiguity
}
\description{
Detect candidate inconsistencies and ambiguity
}
\examples{
sample <- load_sample()
lineages <- get_lineages(sample)
kingdom <- get_validity(lineages, rank = "kingdom", valid = FALSE)
family <- get_validity(lineages, rank = "family", valid = FALSE)
candidates <- list(kingdom, family)
get_inconsistencies(candidates, uninomials = FALSE)
}
