% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabsort.R
\name{tabsort}
\alias{tabsort}
\alias{ntbl}
\title{tabsort}
\usage{
tabsort(.data, ..., prop = TRUE, na_omit = TRUE, sort = TRUE)

ntbl(.data, ...)
}
\arguments{
\item{.data}{Data}

\item{...}{Unquoted column names of variables to include in table. Default
is to use all columns.}

\item{prop}{Logical indicating whether to include a proportion of total
obs column.}

\item{na_omit}{Logical indicating whether to exclude missing. If all
responses are missing, a missing value is used as the single category.}

\item{sort}{Logical indicating whether to sort the returned object.}
}
\value{
Frequency tbl
}
\description{
Returns a sorted (descending) frequency tbl
}
\examples{

## generate example data
x <- sample(letters[1:4], 200, replace = TRUE)
y <- sample(letters[5:8], 200, replace = TRUE)

## count and sort frequencies for each vector
tabsort(x)
tabsort(y)

## combine x and y into data frame
dat <- data.frame(x, y)

## select columns and create freq table
tabsort(dat, x)
tabsort(dat, x, y)

}
