% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/diversity.R
\name{inverse.simpson}
\alias{chao1}
\alias{diversity}
\alias{gini}
\alias{inverse.simpson}
\title{Distribution evaluation.}
\usage{
inverse.simpson(.data, .do.norm = NA, .laplace = 0)

diversity(.data, .q = 5, .do.norm = NA, .laplace = 0)

gini(.data, .do.norm = NA, .laplace = 0)

chao1(.data)
}
\arguments{
\item{.data}{Numeric vector of values for proportions or for numbers of individuals.}

\item{.do.norm}{One of the three values - NA, T or F. If NA than check for distrubution (sum(.data) == 1)
and normalise if needed with the given laplace correction value. If T than do normalisation and laplace
correction. If F than don't do normalisaton and laplace correction.}

\item{.laplace}{Value for Laplace correction which will be added to every value in the .data.}

\item{.q}{q-parameter for the Diversity index.}
}
\value{
Numeric vector of length 1 with value for all functions except \code{chao1}, which returns 4 values:
estimated number of species, standart deviation of this number and two 95% confidence intervals for the species number.
}
\description{
Function for evaluating the diversity of species or objects in the given distribution.

- True diversity, or the effective number of types, refers to the number
of equally-abundant types needed for the average proportional abundance
of the types to equal that observed in the dataset of interest
where all types may not be equally abundant.

- Inverse Simpson index is the effective number of types that is obtained when
the weighted arithmetic mean is used to quantify average
proportional abundance of types in the dataset of interest.

- The Gini coefficient measures the inequality among values
of a frequency distribution (for example levels of income). A Gini coefficient of zero
expresses perfect equality, where all values are the same (for example, where everyone
has the same income). A Gini coefficient of one (or 100 percents ) expresses maximal inequality
among values (for example where only one person has all the income).

- Chao1 estimator is a nonparameteric asymptotic estimator of species richness (number of species in a population).

Functions will check if .data if a distribution of random variable (sum == 1) or not.
To force normalisation and / or to prevent this, set .do.norm to TRUE (do normalisation)
or FALSE (don't do normalisation), respectively.
}
\examples{
data(twb)
# Next two are equal calls:
stopifnot(gini(twb[[1]]$Read.count, TRUE, 0) - 0.7609971 < 1e-07)
stopifnot(gini(twb[[1]]$Percentage, FALSE) - 0.7609971 < 1e-07)
stopifnot(chao1(twb[[1]]$Read.count)[1] == 1e+04)
}
\seealso{
\link{entropy}, \link{similarity}
}

