% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/segments.R
\name{pca.segments}
\alias{pca.segments}
\alias{pca.segments.2D}
\title{Perform PCA on segments frequency data.}
\usage{
pca.segments(.data, .cast.freq.seg = T, ..., .text = T, .do.plot = T)

pca.segments.2D(.data, .cast.freq.seg = T, ..., .text = T, .do.plot = T)
}
\arguments{
\item{.data}{Either data.frame or a list of data.frame or a result obtained from the \code{geneUsage} function.}

\item{.cast.freq.seg}{if T then apply code{geneUsage} to the supplied data.}

\item{...}{Further arguments passed to \code{prcomp} or \code{geneUsage}.}

\item{.text}{If T then plot sample names in the resulting plot.}

\item{.do.plot}{if T then plot a graphic, else return a pca object.}
}
\value{
If .do.plot is T than ggplot object; else pca object.
}
\description{
Perform PCA on gene segments frequency data for V- and J-segments and either return pca object or plot the results.
}
\examples{
\dontrun{
# Load the twins data.
data(twb)
# Plot a plot of results of PCA on V-segments usage.
pca.segments(twb, T, scale. = T)
}
}

