% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plots.R
\name{vis.rarefaction}
\alias{vis.rarefaction}
\title{Rarefaction statistics visualisation.}
\usage{
vis.rarefaction(.muc.res, .groups = NULL, .log = F)
}
\arguments{
\item{.muc.res}{Output from the \code{muc} function.}

\item{.groups}{List with names for groups and names of the group members. If NULL than each
member is in the individual group.}

\item{.log}{if T then log-scale the y axis.}
}
\description{
Plot a line with mean unique clones.
}
\examples{
\dontrun{
data(twb)
names(twb)  # "Subj.A" "Subj.B" "Subj.C" "Subj.D"
twb.rar <- rarefaction(twb, .col = "Read.count")
vis.rarefaction(twb.rar, list(A = c("Subj.A", "Subj.B"), B = c("Subj.C", "Subj.D")))
}
}
\seealso{
\link{rarefaction}
}

