% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.tcensReg.R
\name{vcov.tcensReg}
\alias{vcov.tcensReg}
\title{Method for Returning Covariance of Fixed Parameters for tcensReg S3 Objects}
\usage{
\method{vcov}{tcensReg}(object, logsigma = FALSE, ...)
}
\arguments{
\item{object}{Object of class \code{tcensReg}}

\item{logsigma}{Logical indicator of whether to return standard deviation as logsigma or sigma. Default is FALSE returning sigma}

\item{...}{Additional optional parameters}
}
\value{
Numeric matrix of variance covarince values
}
\description{
Method for Returning Covariance of Fixed Parameters for tcensReg S3 Objects
}
\details{
If \code{logsigma}=TRUE, the default variance covariance matrix is returned.
Otherwise if the parameter sigma is desired then \code{logsigma}=FALSE, and
we use the multivariate delta method to find these values as described below:

Original Asymptotic Result:
\deqn{\theta=(\beta_{1}, \dots, \beta_{(p-1)}, \log(\sigma))^{T}\sim N_{p}(\hat{\theta}, \hat{\Sigma}_{\theta})}

Transformed Parameters:
\deqn{g(\theta)=(\beta_{1}, \dots, \beta_{(p-1)}, \exp\{\log(\sigma)\})^{T}\sim N_{p}(g(\hat{\theta}), \nabla_{g(\theta)}^{T}\hat{\Sigma}_{\theta}\nabla_{g(\theta)})}

The gradient vector is defined as
\deqn{\nabla_{g(\theta)}=diag(1_{p-1}, \log(\sigma)\exp\{\log(\sigma)\})_{p\times p}}
}
\keyword{internal}
