% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tci_algorithms.R
\name{tci}
\alias{tci}
\title{Apply TCI algorithm}
\usage{
tci(
  Ct,
  tms,
  pkmod,
  pars,
  init = NULL,
  tci_alg = c("effect", "plasma"),
  tci_custom = NULL,
  dtm = 1/6,
  ...
)
}
\arguments{
\item{Ct}{Vector of target concentrations}

\item{tms}{Times at which the TCI algorithm should try to achieve the
target concentrations}

\item{pkmod}{PK model}

\item{pars}{PK model parameters}

\item{init}{Initial concentrations for PK model}

\item{tci_alg}{TCI algorithm. Options are provided for effect-site
(default) or plasma targeting. Alternate algorithms can be specified
through the 'tci_custom' argument.}

\item{tci_custom}{Custom TCI algorithm. Algorithm should have arguments
specifying target concentration, PK model, and duration of infusion to
reach the target.}

\item{dtm}{Time difference between infusion rate updates.}

\item{...}{Arguments passed on to TCI algorithm.}
}
\description{
Function to iterate any arbitrary TCI algorithm to a series of points. By default,
the function will update infusion rates at fixed intervals (e.g. every 10 seconds);
however, users will have the option of waiting only calculating infusions after
the prior target has been obtained.
}
\details{
The user passes the `iterate_tci` function a matrix of target concentrations and times
at which the target is set. This is translated into a step function that defines the
concentration target at all times.
}
