% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_mods.R
\name{gen_eleveld_pk_pars_nonmem}
\alias{gen_eleveld_pk_pars_nonmem}
\title{Generate Eleveld model PK parameters}
\usage{
gen_eleveld_pk_pars_nonmem(THETA, ETA, PATIENT_VARS, returnQ = FALSE)
}
\arguments{
\item{THETA}{Vector of fixed effects}

\item{ETA}{Vector of random effect variances}

\item{PATIENT_VARS}{Named list of patient covariate values}

\item{returnQ}{Optional logical value to indicate if clearance values should be returned instead of elimination rate constants.}
}
\value{
Numeric vector of PK parameters for Eleveld propofol model associated
with a set of patient covariates.
}
\description{
R code adapted from NONMEM PK file provided in supplementary material of Eleveld et al. Function takes in fixed effect
parameter estimates and random effect variance estimates to return parameters for a 3 compartment pk model with an
effect site compartment.
}
\examples{
data(eleveld_pk)

# PK fixed effect values and random effect variances from Eleveld et al. (2018)
eleveld_theta_pk_est <- c(6.28,25.5,273,1.79,1.75,1.11,0.191,42.3,9.06,
-0.0156,-0.00286,33.6,-0.0138,68.3,2.10,1.30,1.42,0.68)
eleveld_eta_pk_var <- c(0.610,0.565,0.597,0.265,0.346,0.209,0.463)

# Example patient covariate values, fixed effects, and random effects
patient_covariates <- subset(eleveld_pk, ID == 403,
select = c("AGE","WGT","HGT","M1F2","PMA","TECH","A1V2"))
eta_obs <- c(mvtnorm::rmvnorm(1,sigma = diag(eleveld_eta_pk_var)))
gen_eleveld_pk_pars_nonmem(THETA = eleveld_theta_pk_est,
                           ETA = eta_obs,
                           PATIENT_VARS = patient_covariates)

}
