% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{poppkmod}
\alias{poppkmod}
\title{Implement a population pharmacokinetic/pharmacodynamic model.}
\usage{
poppkmod(
  data,
  drug = c("ppf", "remi"),
  model = c("marsh", "schnider", "eleveld", "minto", "kim"),
  sample = FALSE,
  PD = TRUE,
  ...
)
}
\arguments{
\item{data}{Data frame of patient covariates. ID values, if used, should be in a column labeled "id" or "ID"}

\item{drug}{"ppf" for propofol or "remi" for remifentanil. Defaults to "ppf".}

\item{model}{Model name. Options are "marsh", "schnider", or "eleveld" if
drug = "ppf", or "minto", "kim", or "eleveld" if drug = "remi".}

\item{sample}{Logical. Should parameter values be sampled from interindividual distribution (TRUE)
or evaluated at point estimates for covariates (FALSE)? Defaults to FALSE.}

\item{PD}{Logical. If applicable, should the PD component be evaluated for PK-PD models. Defaults to TRUE.}

\item{...}{Arguments passed on to each pkmod object}
}
\value{
`poppkmod` object
}
\description{
Create a `poppkmod` object using an existing population PK model
for propofol or remifentanil using patient covariates. Available models for
propofol are the Marsh, Schnider, and Eleveld models. Available models for
remifentanil are the Minto, Kim, and Eleveld models. Input is
a data frame with rows corresponding to individuals and columns
recording patient covariates. An ID column is optional, but will be generated
as 1:nrow(data) if not supplied. Covariates required by each model are

 \strong{Propofol}
 \itemize{
  \item Marsh: TBW
  \item Schnider: (AGE, HGT, TBW, MALE) or (AGE, HGT, LBW)
  \item Eleveld: AGE, TBW, HGT, MALE
 }

 \strong{Remifentanil}
 \itemize{
  \item Minto: (AGE, HGT, TBW, MALE) or (AGE, HGT, LBW)
  \item Kim: (AGE, TBW, BMI, HGT) or (AGE, TBW, FFM)
  \item Eleveld: (AGE, MALE, TBW, HGT) or (AGE, MALE, TBW, BMI)
 }

\strong{Abbreviations}
\itemize{
 \item TBW = Total body weight (kg)
 \item LBW = Lean body weight (kg)
 \item FFM = Fat-free mass (kg)
 \item AGE = Age (years)
 \item HGT = Height (cm)
 \item MALE = Male (1/0, TRUE/FALSE)
 \item BMI = Body mass index (kg/\eqn{m^2})
 }
}
\examples{
data <- data.frame(ID = 1:5, AGE = seq(20,60,by=10), TBW = seq(60,80,by=5),
HGT = seq(150,190,by=10), MALE = c(TRUE,TRUE,FALSE,FALSE,FALSE))
poppkmod(data, drug = "ppf", model = "eleveld")
poppkmod(data, drug = "remi", model = "kim")
}
