% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctlcurves.R
\name{plot.ctlcurves}
\alias{plot.ctlcurves}
\title{The \code{plot} method for objects of class \code{ctlcurves}}
\usage{
\method{plot}{ctlcurves}(
  x,
  what = c("obj", "min.weights", "doubtful"),
  main,
  xlab,
  ylab,
  xlim,
  ylim,
  col,
  lty = 1,
  ...
)
}
\arguments{
\item{x}{The ctlcurves object to be shown}

\item{what}{A string indicating which type of plot shall be drawn. See the details section for more information.}

\item{main}{A character-string containing the title of the plot.}

\item{xlab, ylab, xlim, ylim}{Arguments passed to plot().}

\item{col}{A single value or vector of line colors passed to \code{\link[graphics]{lines}}.}

\item{lty}{A single value or vector of line colors passed to \code{\link[graphics]{lines}}.}

\item{\ldots}{Arguments to be passed to or from other methods.}
}
\description{
The \code{plot} method for class \code{ctlcurves}: This function implements 
 a series of plots, which display characteristic values 
 of the each model, computed with different values for \code{k} and \code{alpha}.
}
\details{
These curves show the values of the trimmed classification (log-)likelihoods 
 when altering the trimming proportion \code{alpha} and the number of clusters \code{k}.
 The careful examination of these curves provides valuable information for choosing these 
 parameters in a clustering problem. For instance, an appropriate \code{k} to be chosen 
 is one that we do not observe a clear increase in the trimmed classification likelihood
 curve for \code{k} with respect to the \code{k+1} curve for almost all the range of
 \code{alpha} values. Moreover, an appropriate choice of parameter \code{alpha} may
 be derived by determining where an initial fast increase of the trimmed classification 
 likelihood curve stops for the final chosen \code{k}. A more detailed explanation 
 can be found in García-Escudero et al. (2011).
  
 This function implements a series of plots, which display characteristic values 
 of the each model, computed with different values for \code{k} and \code{alpha}.
 \describe{
   \item{\code{"obj"}}{Objective function values.}
   \item{\code{"min.weights"}}{The minimum cluster weight found for each computed model. 
     This plot is intended to spot spurious clusters, which in 
     general yield quite small weights.}
   \item{\code{"doubtful"}}{The number of "doubtful" decisions identified by \code{\link{DiscrFact}}.}
 }
}
\examples{

 #--- EXAMPLE 1 ------------------------------------------

 sig <- diag (2)
 cen <- rep (1, 2)
 x <- rbind(MASS::mvrnorm(108, cen * 0,   sig),
 	       MASS::mvrnorm(162, cen * 5,   sig * 6 - 2),
 	       MASS::mvrnorm(30, cen * 2.5, sig * 50))

 (ctl <- ctlcurves(x, k = 1:4))

 plot(ctl)
}
\references{
\enc{García}{Garcia}-Escudero, L.A.; Gordaliza, A.; \enc{Matrán}{Matran}, C. and Mayo-Iscar, A. (2011), 
   "Exploring the number of groups in robust model-based clustering." \emph{Statistics and Computing}, \bold{21} 
   pp. 585-599, <doi:10.1007/s11222-010-9194-z>
}
