% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hitcontinner.R
\name{hitcontinner}
\alias{hitcontinner}
\title{Continuous Hitcalls Inner}
\usage{
hitcontinner(
  conc,
  resp,
  top,
  cutoff,
  er,
  ps,
  fit_method,
  caikwt,
  mll,
  errfun = "dt4"
)
}
\arguments{
\item{conc}{Vector of concentrations.}

\item{resp}{Vector of responses.}

\item{top}{Model top.}

\item{cutoff}{Desired cutoff.}

\item{er}{Model error parameter.}

\item{ps}{Vector of used model parameters in order: a, tp, b, ga, p, la, q, er.}

\item{fit_method}{Name of winning fit method (should never be constant).}

\item{caikwt}{Akaike weight of constant model relative to winning model.}

\item{mll}{Maximum log-likelihood of winning model.}

\item{errfun}{Which error distribution to assume for each point, defaults to
"dt4". "dt4" is the original 4 degrees of freedom t-distribution. Another
supported distribution is "dnorm", the normal distribution.}
}
\value{
Continuous hitcall between 0 and 1.
}
\description{
Calculates continuous hitcall using 3 statistical metrics.
}
\details{
This function is called either directly from concRespCore or
via hitcont. Details of how to compute function input are in
concRespCore.
}
\examples{
conc = c(.03,.1,.3,1,3,10,30,100)
resp = c(0,.1,0,.2,.6,.9,1.1,1)
top = 1.023239
er = -3.295307
ps = c(1.033239, 2.453014, 1.592714, er = -3.295307) #tp,ga,p,er
fit_method = "hill"
caikwt = 1.446966e-08
mll = 12.71495
hitcontinner(conc,resp,top,cutoff = 0.8, er,ps,fit_method, caikwt, mll)
hitcontinner(conc,resp,top,cutoff = 1, er,ps,fit_method, caikwt, mll)
hitcontinner(conc,resp,top,cutoff = 1.2, er,ps,fit_method, caikwt, mll)
}
