% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSymbolInfo.R
\name{getSymbolInfo}
\alias{getSymbolInfo}
\title{Information for instrument. by figi}
\usage{
getSymbolInfo(token = "", live = FALSE, figi = "", verbose = FALSE)
}
\arguments{
\item{token}{token from Tinkoff account}

\item{live}{live trading - TRUE or sandbox (paper) trading - FALSE (default)}

\item{figi}{internal tinkoff code for instrument}

\item{verbose}{display status of retrieval (default FALSE)}
}
\value{
returns an data.table object containing the information about instrument.
}
\description{
Makes a request to the server, and returns an data.table object with information about instrument if successful.
}
\details{
As described by the official Tinkoff Investments documentation
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
live = FALSE
token = 'your_sandbox_token_from_tcs_account'
getSymbolInfo(token,live,figi = 'BBG005HLTYH9')
}
\seealso{
\code{\link{getTickerInfo}}
}
\author{
Vyacheslav Arbuzov
}
