% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-pd-degree.R
\name{step_pd_degree}
\alias{step_pd_degree}
\alias{tidy.step_pd_degree}
\title{Separate persistent pairs by homological degree}
\usage{
step_pd_degree(
  recipe,
  ...,
  role = "persistence diagram",
  trained = FALSE,
  hom_degrees = NULL,
  columns = NULL,
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("pd_degree")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables for this step.
See \code{\link[recipes:selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from the
original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{hom_degrees}{Integer vector of homological degrees.}

\item{columns}{A character string of the selected variable names. This field
is a placeholder and will be populated once \code{\link[recipes:prep]{prep()}} is used.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\code{\link[recipes:bake]{bake()}}? While all operations are baked when \code{\link[recipes:prep]{prep()}} is run, some
operations may not be able to be conducted on new data (e.g. processing the
outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it
may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
The function \code{step_pd_degree()} creates a \emph{specification} of a
recipe step that will separate data sets of persistent pairs by homological
degree. The input and output must be list-columns.
}
\details{
Additional details...

The \code{hom_degrees} argument sets the homological degrees for which to return
new list-columns. If not \code{NULL} (the default), it is intersected with the
degrees found in any specified columns of the training data; otherwise all
found degrees are used. This parameter cannot be tuned.
}
\examples{
dat <- data.frame(
  roads = I(list(eurodist, UScitiesD * 1.6)),
  topos = I(list(volcano, 255 - volcano))
)

ph_rec <- recipe(~ ., data = dat) \%>\% 
  step_pd_point_cloud(roads, keep_original_cols = FALSE) \%>\% 
  step_pd_raster(topos, keep_original_cols = FALSE) \%>\% 
  step_pd_degree(roads_pd, topos_pd)
ph_prep <- prep(ph_rec, training = dat)
(ph_res <- bake(ph_prep, dat))

tidy(ph_rec, number = 3)
tidy(ph_prep, number = 3)

with_degs <- recipe(~ ., data = dat) \%>\% 
  step_pd_point_cloud(roads, keep_original_cols = FALSE) \%>\% 
  step_pd_raster(topos, keep_original_cols = FALSE) \%>\% 
  step_pd_degree(roads_pd, topos_pd, hom_degrees = c(1, 2))
with_degs <- prep(with_degs, training = dat)
bake(with_degs, dat)
}
\seealso{
Other topological feature extraction via persistent homology: 
\code{\link{step_pd_point_cloud}()},
\code{\link{step_pd_raster}()}
}
\concept{topological feature extraction via persistent homology}
