% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R, R/util.R
\name{td_create}
\alias{td_create}
\alias{is_tdigest}
\title{Allocate a new histogram}
\usage{
td_create(compression = 100)

is_tdigest(td)
}
\arguments{
\item{compression}{the input compression value; should be >= 1.0; this
will control how aggressively the t-Digest compresses data together.
The original t-Digest paper suggests using a value of 100 for a good
balance between precision and efficiency. It will land at very small
(think like 1e-6 percentile points) errors at extreme points in the
distribution, and compression ratios of around 500 for large data sets
(~1 million datapoints). Defaults to 100.}

\item{td}{t-digest object}
}
\value{
a \code{tdigest} object
}
\description{
Allocate a new histogram
}
\examples{
td <- td_create(10)
}
\references{
\href{https://arxiv.org/abs/1902.04023}{Computing Extremely Accurate Quantiles Using t-Digests}
}
