% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_server.R
\name{add_server}
\alias{add_server}
\title{Add the server of one app to the server of another app}
\usage{
add_server(app, env = NULL, pkg = "teachingApps")
}
\arguments{
\item{app}{The name of the app from which the content of the \code{server.R} will be pulled}

\item{env}{The environment in which the call is made typically \code{environment()}}

\item{pkg}{The package in which \code{app} exists (defaults to \code{teachingApps})}
}
\value{
An \code{Observer}-class object resulting from evaluating a \code{server.R} file
}
\description{
Sources a \code{server.R} file before parsing and evaluating its contents in a specified environment
}
\details{
Currently, this function can be used to insert an \code{server} into
         a \code{navbarPage} app.  The types of apps that can be inserted are:
         
     \itemize{
         \item{\code{fluidPage}}{}
         \item{\code{bootstrapPage}}{}
         \item{\code{pageWithSidebar}}{}
         \item{\code{basicPage}}{}
         \item{\code{fixedPage}}{}
      }          
         A \code{server} can be added as an entire \code{tabPanel} or as a row within 
         within a \code{tabPanel} portion of a shiny app. 
         
         May be used with apps stored in packages other than teachingApps.  
         However, apps are assumed be stored in the \code{apps/} directory located 
         at top level of the package.
}
\examples{
\dontrun{

## server.R from app: 'maximum_likelihood'

server_ml <- system.file('apps', 
                         'maximum_likelihood',
                         'server.R',
                         package = 'teachingApps') 
browseURL(server_ml)

## server.R from app: 'distribution_weibull'

server_dw <- system.file('apps', 
                         'distribution_weibull',
                         'server.R',
                         package = 'teachingApps') 
browseURL(server_dw)

}
}
\seealso{
\code{\link{add_ui}},  \code{\link{add_rmd}}
}
