% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Four Parameter Beta}
\alias{Four Parameter Beta}
\alias{dbeta4}
\alias{pbeta4}
\alias{qbeta4}
\alias{rbeta4}
\title{The Four Parameter Beta Distribution}
\source{
Birnbaum, Z. W.; Saunders, S. C. (1969), "A new family of life distributions", Journal of Applied Probability, 6 (2): 319–327, JSTOR 3212003, doi:10.2307/3212003
}
\usage{
dbeta4(x, min, max, shape1, shape2, gap = 0)

pbeta4(q, min, max, shape1, shape2, gap = 0)

qbeta4(p, min, max, shape1, shape2)

rbeta4(n, min, max, shape1, shape2, seed = 42)
}
\arguments{
\item{x}{Vector of quantiles}

\item{min}{The minumum value on which the distribution is defined}

\item{max}{The maximum value on which the distribution is defined}

\item{shape1}{Shape parameter}

\item{shape2}{Shape parameter}

\item{gap}{Spacing from \code{min} and \code{max}}

\item{q}{Vector of quantiles}

\item{p}{Vector of probabilities}

\item{n}{Number of observations}

\item{seed}{A numeric value for the seed of the random number generator}
}
\value{
\code{dbeta4} gives the density, 
        \code{pbeta4} gives the distribution function, 
        \code{qbeta4} gives the quantile function, and 
        \code{rbeta4} generates random observations.
        
        The length of the result is determined by \code{n} 
        for \code{rbeta4}, and is the maximum of the lengths 
        of the numerical arguments for the other functions. 
        
        The numerical arguments other than \code{n} are 
        recycled to the length of the result.
}
\description{
Density, distribution function, quantile function and 
             random generation for the four parameter Beta distribution 
             with minimum value \code{min} and scale \code{scale}.
}
\details{
If \code{shape} is not specified, a default 
         value of 1 is used.
         
         The Birmbaum-Saunders distribution with shape \eqn{\beta} and
         scale \eqn{\theta} has density
         
         \deqn{f(x;\theta,\beta) = \frac{\sqrt{\frac{x}{\theta}}+\sqrt{\frac{\theta}{x}}}{2\beta x}\phi_{_{NOR}(z)},\quad x \ge 0 }
         
         where \eqn{\phi_{_{NOR}}(z)} is the density of the standard normal distribution and  
         
         \deqn{z = \frac{1}{\beta}\left(\sqrt{\frac{x}{\theta}}-\sqrt{\frac{\theta}{x} } \right)}.
}
