#' Reproducible class with environment and code
#'
#' Reproducible class with environment and code.
#' @name qenv-class
#' @rdname qenv-class
#' @slot code (`character`) representing code necessary to reproduce the environment
#' @slot env (`environment`) environment which content was generated by the evaluation
#'  of the `code` slot.
#' @slot id (`integer`) random identifier of the code element to make sure uniqueness
#'  when joining.
#' @slot warnings (`character`) the warnings output when evaluating the code
#' @slot messages (`character`) the messages output when evaluating the code
#' @keywords internal
#' @exportClass qenv
setClass(
  "qenv",
  slots = c(env = "environment", code = "character", id = "integer", warnings = "character", messages = "character"),
  prototype = list(
    env = new.env(parent = parent.env(.GlobalEnv)), code = character(0), id = integer(0),
    warnings = character(0), messages = character(0)
  )
)

#' It takes a `qenv` class and returns `TRUE` if the input is valid
#' @name qenv-class
#' @keywords internal
setValidity("qenv", function(object) {
  if (length(object@code) != length(object@id)) {
    "@code and @id slots must have the same length."
  } else if (length(object@code) != length(object@warnings)) {
    "@code and @warnings slots must have the same length"
  } else if (length(object@code) != length(object@messages)) {
    "@code and @messages slots must have the same length"
  } else if (any(duplicated(object@id))) {
    "@id contains duplicated values."
  } else {
    TRUE
  }
})
