% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_forest_tte.R
\name{template_forest_tte}
\alias{template_forest_tte}
\title{Template: Survival Forest Plot}
\usage{
template_forest_tte(
  dataname = "ANL",
  parentname = "ANL_ADSL",
  arm_var,
  ref_arm = NULL,
  comp_arm = NULL,
  obj_var_name = "",
  aval_var = "AVAL",
  cnsr_var = "CNSR",
  subgroup_var,
  strata_var = NULL,
  conf_level = 0.95,
  col_symbol_size = NULL,
  time_unit_var = "AVALU",
  ggplot2_args = teal.widgets::ggplot2_args()
)
}
\arguments{
\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{character})\cr variable names that can be used as \code{arm_var}.}

\item{ref_arm}{(\code{character})\cr the level of reference arm in case of arm comparison.}

\item{comp_arm}{(\code{character})\cr the level of comparison arm in case of arm comparison.}

\item{obj_var_name}{(\code{character})\cr additional text to append to the table title.}

\item{aval_var}{(\code{character})\cr name of the analysis value variable.}

\item{cnsr_var}{(\code{character})\cr name of the censoring variable.}

\item{subgroup_var}{(\code{character})\cr with variable names that can be used as subgroups.}

\item{strata_var}{(\code{character})\cr names of the variables for stratified analysis.}

\item{conf_level}{(\code{numeric})\cr value for the confidence level within the range of (0, 1).}

\item{col_symbol_size}{(\code{integer} or \code{NULL})\cr column index to be used to determine relative size for
estimator plot symbol. Typically, the symbol size is proportional to the sample size used
to calculate the estimator. If \code{NULL}, the same symbol size is used for all subgroups.}

\item{time_unit_var}{(\code{character})\cr name of the variable representing time units.}

\item{ggplot2_args}{optional, (\code{ggplot2_args})\cr object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings
for the module plot. The argument is merged with option \code{teal.ggplot2_args} and with default module arguments
(hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}
}
\value{
a \code{list} of expressions to generate a table or plot object.
}
\description{
Creates a valid expression to generate a survival forest plot.
}
\seealso{
\code{\link[=tm_g_forest_tte]{tm_g_forest_tte()}}
}
\keyword{internal}
