% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_km.R
\name{tm_g_km}
\alias{tm_g_km}
\title{teal Module: Kaplan-Meier Plot}
\usage{
tm_g_km(
  label,
  dataname,
  parentname = ifelse(inherits(arm_var, "data_extract_spec"),
    teal.transform::datanames_input(arm_var), "ADSL"),
  arm_var,
  arm_ref_comp = NULL,
  paramcd,
  strata_var,
  facet_var,
  time_unit_var =
    teal.transform::choices_selected(teal.transform::variable_choices(dataname, "AVALU"),
    "AVALU", fixed = TRUE),
  aval_var = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    "AVAL"), "AVAL", fixed = TRUE),
  cnsr_var = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    "CNSR"), "CNSR", fixed = TRUE),
  conf_level = teal.transform::choices_selected(c(0.95, 0.9, 0.8), 0.95, keep_order =
    TRUE),
  plot_height = c(1200L, 400L, 5000L),
  plot_width = NULL,
  pre_output = NULL,
  post_output = NULL
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for variable names that can be used as \code{arm_var}.
It defines the grouping variable(s) in the results table.
If there are two elements selected for \code{arm_var},
second variable will be nested under the first variable.}

\item{arm_ref_comp}{optional, (\code{list})\cr If specified it must be a named list with each element corresponding to
an arm variable in \code{ADSL} and the element must be another list (possibly
with delayed \code{\link[teal.transform:variable_choices]{teal.transform::variable_choices()}} or delayed \code{\link[teal.transform:value_choices]{teal.transform::value_choices()}}
with the elements named \code{ref} and \code{comp} that the defined the default
reference and comparison arms when the arm variable is changed.}

\item{paramcd}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the parameter code variable from \code{dataname}.}

\item{strata_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr names of
the variables for stratified analysis.}

\item{facet_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and preselected option for names of variable that can be used for plot faceting.}

\item{time_unit_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object
with all available choices and pre-selected option for the time unit variable.}

\item{aval_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and pre-selected option for the analysis variable.}

\item{cnsr_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the censoring variable.}

\item{conf_level}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and pre-selected option for the confidence level, each within range of (0, 1).}

\item{plot_height}{optional, (\code{numeric})\cr a vector of length three with \code{c(value, min, max)}. Specifies the
height of the main plot and renders a slider on the plot to interactively adjust the plot height.}

\item{plot_width}{optional, (\code{numeric})\cr a vector of length three with \code{c(value, min, max)}. Specifies the width
of the main plot and renders a slider on the plot to interactively adjust the plot width.}

\item{pre_output}{optional, (\code{shiny.tag})\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{optional, (\code{shiny.tag})\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a grid-style Kaplan-Meier plot for data with ADaM structure.
}
\examples{
library(nestcolor)

ADSL <- tmc_ex_adsl
ADTTE <- tmc_ex_adtte

arm_ref_comp <- list(
  ACTARMCD = list(
    ref = "ARM B",
    comp = c("ARM A", "ARM C")
  ),
  ARM = list(
    ref = "B: Placebo",
    comp = c("A: Drug X", "C: Combination")
  )
)

app <- init(
  data = cdisc_data(
    ADSL = ADSL,
    ADTTE = ADTTE,
    code = "
      ADSL <- tmc_ex_adsl
      ADTTE <- tmc_ex_adtte
    "
  ),
  modules = modules(
    tm_g_km(
      label = "Kaplan-Meier Plot",
      dataname = "ADTTE",
      arm_var = choices_selected(
        variable_choices(ADSL, c("ARM", "ARMCD", "ACTARMCD")),
        "ARM"
      ),
      paramcd = choices_selected(
        value_choices(ADTTE, "PARAMCD", "PARAM"),
        "OS"
      ),
      arm_ref_comp = arm_ref_comp,
      strata_var = choices_selected(
        variable_choices(ADSL, c("SEX", "BMRKR2")),
        "SEX"
      ),
      facet_var = choices_selected(
        variable_choices(ADSL, c("SEX", "BMRKR2")),
        NULL
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
The \href{https://insightsengineering.github.io/tlg-catalog/stable/}{TLG Catalog} where additional example
apps implementing this module can be found.
}
