% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Archiver.R
\docType{class}
\name{JSONArchiver}
\alias{JSONArchiver}
\title{\code{JSONArchiver}: A \code{JSON}-based \code{Archiver}}
\description{
Inherits from \code{FileArchiver} to implement \code{JSON}-based archiving functionality.
Convert \code{Reporter} instances to and from \code{JSON} format.
}
\examples{

## ------------------------------------------------
## Method `JSONArchiver$write`
## ------------------------------------------------

library(ggplot2)

ReportCard <- getFromNamespace("ReportCard", "teal.reporter")
card1 <- ReportCard$new()

card1$append_text("Header 2 text", "header2")
card1$append_text("A paragraph of default text", "header2")
card1$append_plot(
 ggplot(iris, aes(x = Petal.Length)) + geom_histogram()
)

Reporter <- getFromNamespace("Reporter", "teal.reporter")
reporter <- Reporter$new()
reporter$append_cards(list(card1))

JSONArchiver <- getFromNamespace("JSONArchiver", "teal.reporter")
archiver <- JSONArchiver$new()
archiver$write(reporter)
archiver$get_output_dir()

## ------------------------------------------------
## Method `JSONArchiver$read`
## ------------------------------------------------

library(ggplot2)

ReportCard <- getFromNamespace("ReportCard", "teal.reporter")
card1 <- ReportCard$new()

card1$append_text("Header 2 text", "header2")
card1$append_text("A paragraph of default text", "header2")
card1$append_plot(
 ggplot(iris, aes(x = Petal.Length)) + geom_histogram()
)

Reporter <- getFromNamespace("Reporter", "teal.reporter")
reporter <- Reporter$new()
reporter$append_cards(list(card1))

JSONArchiver <- getFromNamespace("JSONArchiver", "teal.reporter")
archiver <- JSONArchiver$new()
archiver$write(reporter)
archiver$get_output_dir()

archiver$read()$get_cards()[[1]]$get_content()
Reporter <- getFromNamespace("Reporter", "teal.reporter")
blocks <- Reporter$new()
blocks <- blocks$from_reporter(archiver$read())$get_blocks()
Renderer <- getFromNamespace("Renderer", "teal.reporter")
doc <- Renderer$new()$render(blocks)
}
\keyword{internal}
\section{Super classes}{
\code{\link[teal.reporter:Archiver]{teal.reporter::Archiver}} -> \code{\link[teal.reporter:FileArchiver]{teal.reporter::FileArchiver}} -> \code{JSONArchiver}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-JSONArchiver-write}{\code{JSONArchiver$write()}}
\item \href{#method-JSONArchiver-read}{\code{JSONArchiver$read()}}
\item \href{#method-JSONArchiver-clone}{\code{JSONArchiver$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="FileArchiver" data-id="finalize"><a href='../../teal.reporter/html/FileArchiver.html#method-FileArchiver-finalize'><code>teal.reporter::FileArchiver$finalize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="FileArchiver" data-id="get_output_dir"><a href='../../teal.reporter/html/FileArchiver.html#method-FileArchiver-get_output_dir'><code>teal.reporter::FileArchiver$get_output_dir()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="FileArchiver" data-id="initialize"><a href='../../teal.reporter/html/FileArchiver.html#method-FileArchiver-initialize'><code>teal.reporter::FileArchiver$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-JSONArchiver-write"></a>}}
\if{latex}{\out{\hypertarget{method-JSONArchiver-write}{}}}
\subsection{Method \code{write()}}{
Write a \code{Reporter} instance in \code{JSON} file.
Serializes a given \code{Reporter} instance and saves it in the \code{Archiver}'s output directory,
to this \code{JSONArchiver} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JSONArchiver$write(reporter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reporter}}{(\code{Reporter}) instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(ggplot2)

ReportCard <- getFromNamespace("ReportCard", "teal.reporter")
card1 <- ReportCard$new()

card1$append_text("Header 2 text", "header2")
card1$append_text("A paragraph of default text", "header2")
card1$append_plot(
 ggplot(iris, aes(x = Petal.Length)) + geom_histogram()
)

Reporter <- getFromNamespace("Reporter", "teal.reporter")
reporter <- Reporter$new()
reporter$append_cards(list(card1))

JSONArchiver <- getFromNamespace("JSONArchiver", "teal.reporter")
archiver <- JSONArchiver$new()
archiver$write(reporter)
archiver$get_output_dir()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-JSONArchiver-read"></a>}}
\if{latex}{\out{\hypertarget{method-JSONArchiver-read}{}}}
\subsection{Method \code{read()}}{
Read a \code{Reporter} instance from a \code{JSON} file.
Converts a \code{Reporter} instance from the \code{JSON} file in the \code{JSONArchiver}'s output directory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JSONArchiver$read(path = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(\code{character(1)}) a path to the directory with all proper files.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{Reporter} instance.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(ggplot2)

ReportCard <- getFromNamespace("ReportCard", "teal.reporter")
card1 <- ReportCard$new()

card1$append_text("Header 2 text", "header2")
card1$append_text("A paragraph of default text", "header2")
card1$append_plot(
 ggplot(iris, aes(x = Petal.Length)) + geom_histogram()
)

Reporter <- getFromNamespace("Reporter", "teal.reporter")
reporter <- Reporter$new()
reporter$append_cards(list(card1))

JSONArchiver <- getFromNamespace("JSONArchiver", "teal.reporter")
archiver <- JSONArchiver$new()
archiver$write(reporter)
archiver$get_output_dir()

archiver$read()$get_cards()[[1]]$get_content()
Reporter <- getFromNamespace("Reporter", "teal.reporter")
blocks <- Reporter$new()
blocks <- blocks$from_reporter(archiver$read())$get_blocks()
Renderer <- getFromNamespace("Renderer", "teal.reporter")
doc <- Renderer$new()$render(blocks)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-JSONArchiver-clone"></a>}}
\if{latex}{\out{\hypertarget{method-JSONArchiver-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JSONArchiver$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
