% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validations.R
\name{validate_has_variable}
\alias{validate_has_variable}
\title{Validates that dataset contains specific variable}
\usage{
validate_has_variable(data, varname, msg)
}
\arguments{
\item{data}{(\code{data.frame})}

\item{varname}{(\code{character(1)}) name of variable to check for in \code{data}}

\item{msg}{(\code{character(1)}) message to display if \code{data} does not include \code{varname}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
This function is a wrapper for \code{shiny::validate}.
}
\examples{
data <- data.frame(
  one = rep("a", length.out = 20),
  two = rep(c("a", "b"), length.out = 20)
)
ui <- fluidPage(
  selectInput(
    "var",
    "Select variable",
    choices = c("one", "two", "three", "four"),
    selected = "one"
  ),
  verbatimTextOutput("summary")
)

server <- function(input, output) {
  output$summary <- renderText({
    validate_has_variable(data, input$var)
    paste0("Selected treatment variables: ", paste(input$var, collapse = ", "))
  })
}
if (interactive()) {
  shinyApp(ui, server)
}
}
