% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{PoR_map}
\alias{PoR_map}
\title{Plot data in PoR map}
\usage{
PoR_map(x, PoR, pb = NULL, cw, deviation = FALSE, ...)
}
\arguments{
\item{x, pb}{#' @param x,pb \code{sf} objects of the data points and the plate boundary
geometries in the geographical coordinate system}

\item{PoR}{Pole of Rotation. \code{"data.frame"} or object of class \code{"euler.pole"}
containing the geographical coordinates of the Pole of Rotation}

\item{cw}{logical. Whether the  displacement of the tangential plate boundary
is clockwise or counterclockwise?}

\item{deviation}{logical.
Whether the data should be color-coded according to the deviation from the
prediction, or according to the stress regime?}

\item{...}{optional arguments passed to \code{\link[=tectonicr.colors]{tectonicr.colors()}}}
}
\value{
plot
}
\description{
Plot data in PoR map
}
\examples{
data("nuvel1")
na_pa <- subset(nuvel1, nuvel1$plate.rot == "na")

data("plates")
plate_boundary <- subset(plates, plates$pair == "na-pa")

data("san_andreas")
PoR_map(san_andreas, PoR = na_pa, pb = plate_boundary, cw = FALSE, deviation = TRUE)
}
\seealso{
\code{\link[=PoR_shmax]{PoR_shmax()}}, \code{\link[=axes]{axes()}}, \code{\link[=tectonicr.colors]{tectonicr.colors()}}
}
