% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{circular_sd_error}
\alias{circular_sd_error}
\title{Standard Error of Mean Direction of Circular Data}
\usage{
circular_sd_error(x, w = NULL, axial = TRUE, na.rm = TRUE)
}
\arguments{
\item{x}{numeric vector. Values in degrees.}

\item{w}{(optional) Weights. A vector of positive numbers and of the same
length as \code{x}.}

\item{axial}{logical. Whether the data are axial, i.e. pi-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{na.rm}{logical value indicating whether \code{NA} values in \code{x}
should be stripped before the computation proceeds.}
}
\value{
Angle in degrees
}
\description{
Measure of the chance variation expected from sample to sample in estimates of the mean direction.
The approximated standard error of the mean direction is computed by the mean
resultant length and the MLE concentration parameter \eqn{\kappa}.
}
\examples{
# Example data from Davis (1986), pp. 316
finland_stria <- c(
  23, 27, 53, 58, 64, 83, 85, 88, 93, 99, 100, 105, 113,
  113, 114, 117, 121, 123, 125, 126, 126, 126, 127, 127, 128, 128, 129, 132,
  132, 132, 134, 135, 137, 144, 145, 145, 146, 153, 155, 155, 155, 157, 163,
  165, 171, 172, 179, 181, 186, 190, 212
)
circular_sd_error(finland_stria, axial = FALSE)

data(san_andreas)
data("nuvel1")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
sa.por <- PoR_shmax(san_andreas, PoR, "right")
circular_sd_error(sa.por$azi.PoR, w = 1 / san_andreas$unc)
}
\references{
Davis (1986) Statistics and data analysis in geology. 2nd ed., John Wiley & Sons.
}
\seealso{
\code{\link[=mean_resultant_length]{mean_resultant_length()}}, \code{\link[=circular_mean]{circular_mean()}}
}
