% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_models.R
\docType{data}
\name{cpm_models}
\alias{cpm_models}
\title{Global model of current plate motions}
\format{
An object of class \code{data.frame}
\describe{
\item{plate.name}{The rotating plate}
\item{plate.rot}{The abbreviation of the plate's name}
\item{lat,lon}{Coordinates of the Pole of Rotation}
\item{angle}{The amount of rotation (angle in 1 Myr)}
\item{plate.fix}{The anchored plate, i.e. \code{plate.rot} moves relative
to  \code{plate.fix}}
\item{model}{Model for current global plate motion}
}
}
\usage{
data('cpm_models')
}
\description{
Compilation of global models for current plate motions, including
NNR-NUVEL1A (DeMets et al., 1990),
NNR-MORVEL56 (Argus et al., 2011),
REVEL (Sella et al., 2002),
GSRM2.1 (Kreemer et al., 2014)
HS-NUVEL1A (Gripp and Gordon, 2002), and
PB2002 (Bird, 2003)
}
\examples{
data("cpm_models")
head("cpm_models")
}
\references{
Argus, D. F., Gordon, R. G., & DeMets, C. (2011). Geologically
current motion of 56 plates relative to the no-net-rotation reference frame.
\emph{Geochemistry, Geophysics, Geosystems}, \strong{12}(11).
doi: 10.1029/2011GC003751.

Bird, P. (2003), An updated digital model of plate boundaries,
\emph{Geochem. Geophys. Geosyst.}, \strong{4}, 1027, doi: 10.1029/2001GC000252, 3.

DeMets, C., Gordon, R. G., Argus, D. F., & Stein, S. (1990).
Current plate motions. \emph{Geophysical Journal International}, \strong{101}(2),
425-478. \doi{10.1111/j.1365-246X.1990.tb06579.x}.

Gripp, A. E., & Gordon, R. G. (2002). Young tracks of hotspots and current
plate velocities. \emph{Geophysical Journal International}, \strong{150}(2), 321–361.
\doi{10.1046/j.1365-246X.2002.01627.x}.

Kreemer, C., Blewitt, G., & Klein, E. C. (2014). A geodetic plate motion
and Global Strain Rate Model. \emph{Geochemistry, Geophysics, Geosystems},
\strong{15}(10), 3849–3889. doi: 10.1002/2014GC005407.

Sella, G. F., Dixon, T. H., & Mao, A. (2002). REVEL: A model for Recent
plate velocities from space geodesy. \emph{Journal of Geophysical Research: Solid
Earth}, \strong{107}(B4). doi: 10.1029/2000jb000033.
}
\keyword{datasets}
