% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{quick_plot}
\alias{quick_plot}
\title{Plotting Stress Analysis Results}
\usage{
quick_plot(azi, distance, prd, unc = NULL, regime, width = 51)
}
\arguments{
\item{azi}{numeric. Azimuth of \eqn{\sigma_{Hmax}}{SHmax}}

\item{distance}{numeric. Distance to plate boundary}

\item{prd}{numeric. the predicted direction of \eqn{\sigma_{Hmax}}{SHmax}}

\item{unc}{numeric. Uncertainty of observed \eqn{\sigma_{Hmax}}{SHmax},
either a numeric vector or a number}

\item{regime}{character vector. The stress
regime (following the classification of the World Stress Map)}

\item{width}{integer. window width (in number of observations) for moving
average of the azimuths, circular dispersion, and Norm Chi-square statistics.
If \code{NULL}, an optimal width will be estimated.}
}
\value{
four R base plots
}
\description{
Creates a set of plots including
the azimuth as a function of the distance to the plate boundary,
the Norm Chi-squared as a function of the distance to the plate boundary,
the circular distance (and dispersion) a function of the distance to the
plate boundary, a von-Mises QQ plot, and a rose diagram of the
quality-weighted frequency distribution of the azimuths.
}
\details{
Plot 1 shows the transformed azimuths as a function of the distance to the
plate boundary. The red line indicates the rolling circular mean, stippled
red lines indicate the 95\% confidence interval about the mean.

Plot 2 shows the normalized \eqn{\chi^2}{chi-squared} statistics as a
function of the distance to the plate boundary. The red line shows the
rolling \eqn{\chi^2}{chi-squared} statistic.

Plot 3 shows the circular distance of the transformed azimuths to the
predicted azimuth, as a function of the distance to the plate boundary. The
red line shows the rolling circular dispersion about the prediction.

Plot 4 give the rose diagram of the transformed azimuths.
}
\examples{
data("nuvel1")
na_pa <- subset(nuvel1, nuvel1$plate.rot == "na")

data("plates")
plate_boundary <- subset(plates, plates$pair == "na-pa")

data("san_andreas")
res <- PoR_shmax(san_andreas, na_pa, "right")
d <- distance_from_pb(san_andreas, na_pa, plate_boundary, tangential = TRUE)
quick_plot(res$azi.PoR,
  distance = d, prd = res$prd, unc = san_andreas$unc,
  regime = san_andreas$regime
)
}
\seealso{
\code{\link[=PoR_shmax]{PoR_shmax()}}, \code{\link[=distance_from_pb]{distance_from_pb()}}, \code{\link[=circular_mean]{circular_mean()}},
\code{\link[=circular_dispersion]{circular_dispersion()}}, \code{\link[=confidence_interval_fisher]{confidence_interval_fisher()}}, \code{\link[=norm_chisq]{norm_chisq()}},
\code{\link[=weighted_rayleigh]{weighted_rayleigh()}}, \code{\link[=vm_qqplot]{vm_qqplot()}}
}
