% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maternEffectiveRange.R
\name{maternEffectiveRange}
\alias{maternEffectiveRange}
\title{Compute effective range for Matern correlation to drop to a specified level}
\usage{
maternEffectiveRange(cor = 0.05, range = 1, smoothness = 0.5)
}
\arguments{
\item{cor}{Effective correlation to check for}

\item{range}{Matern range parameter.  Controls the decay of pointwise 
correlations as a function of distance.}

\item{smoothness}{Matern smoothness parameter.  Controls the number of 
process derivatives.}
}
\description{
The effective range for an isotropic spatial correlation function is 
commonly defined to be the distance beyond which the correlation becomes 
small, typically below .05.  Given range and smoothness parameters for a 
Matern covariance function, this function numerically searches for this 
distance.  Note that the scale is not important for this calculation.
}
\examples{

# effective range for exponential covariance function with range = 1,
# which is theoretically known to equal -ln(.05)
maternEffectiveRange(cor = .05, range = 1, smoothness = .5)

}
