% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bot.R
\name{sendAnimation}
\alias{sendAnimation}
\title{Send animation files}
\usage{
sendAnimation(chat_id, animation, duration = NULL, width = NULL,
  height = NULL, caption = NULL, parse_mode = NULL,
  disable_notification = FALSE, reply_to_message_id = NULL,
  reply_markup = NULL)
}
\arguments{
\item{chat_id}{Unique identifier for the target chat or username of
the target channel.}

\item{animation}{Animation to send. Pass a file_id as String to send an animation that exists on
the Telegram servers (recommended), pass an HTTP URL as a String for Telegram to
get an animation from the Internet, or upload a local file by passing a file path.}

\item{duration}{(Optional). Duration of sent audio in seconds.}

\item{width}{(Optional). Video width.}

\item{height}{(Optional). Video height.}

\item{caption}{(Optional). Animation caption, 0-1024 characters.}

\item{parse_mode}{(Optional). Send 'Markdown' or 'HTML', if you want Telegram apps to show bold,
italic, fixed-width text or inline URLs in your bot's message.}

\item{disable_notification}{(Optional). Sends the message silently. Users will
receive a notification with no sound.}

\item{reply_to_message_id}{(Optional). If the message is a reply, ID of the
original message.}

\item{reply_markup}{(Optional). A Reply Markup parameter object, it can be either:
\itemize{
 \item{\code{\link{ReplyKeyboardMarkup}}}
 \item{\code{\link{InlineKeyboardMarkup}}}
 \item{\code{\link{ReplyKeyboardRemove}}}
 \item{\code{\link{ForceReply}}}}}
}
\description{
Use this method to send animation files (GIF or H.264/MPEG-4 AVC video without sound).
}
\details{
You can also use it's snake_case equivalent \code{send_animation}.
}
\examples{
\dontrun{
bot <- Bot(token = bot_token("RTelegramBot"))
chat_id <- user_id("Me")
animation_url <- "http://techslides.com/demos/sample-videos/small.mp4"

bot$sendAnimation(chat_id = chat_id,
                  animation = animation_url)
}
}
