% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bot.R
\name{sendVideoNote}
\alias{sendVideoNote}
\title{Send video messages}
\usage{
sendVideoNote(
  chat_id,
  video_note,
  duration = NULL,
  length = NULL,
  disable_notification = FALSE,
  reply_to_message_id = NULL,
  reply_markup = NULL
)
}
\arguments{
\item{chat_id}{Unique identifier for the target chat or username of
the target channel.}

\item{video_note}{Video note file to send. Pass a file_id as String to send
a video note that exists on the Telegram servers (recommended), pass an
HTTP URL as a String for Telegram to get a video note from the Internet,
or upload a local video note file by passing a file path.}

\item{duration}{(Optional). Duration of sent audio in seconds.}

\item{length}{(Optional). Video width and height.}

\item{disable_notification}{(Optional). Sends the message silently. Users
will receive a notification with no sound.}

\item{reply_to_message_id}{(Optional). If the message is a reply, ID of the
original message.}

\item{reply_markup}{(Optional). A Reply Markup parameter object, it can be
either:
\itemize{
 \item{\code{\link{ReplyKeyboardMarkup}}}
 \item{\code{\link{InlineKeyboardMarkup}}}
 \item{\code{\link{ReplyKeyboardRemove}}}
 \item{\code{\link{ForceReply}}}}}
}
\description{
Use this method to send video messages.
}
\details{
You can also use it's snake_case equivalent \code{send_video_note}.
}
\examples{
\dontrun{
bot <- Bot(token = bot_token("RTelegramBot"))
chat_id <- user_id("Me")
video_note_url <- "http://techslides.com/demos/sample-videos/small.mp4"

bot$sendVideoNote(
  chat_id = chat_id,
  video_note = video_note_url
)
}
}
