% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcata.R
\encoding{UTF-8}
\name{count.selections}
\alias{count.selections}
\title{Count attribute selections}
\usage{
count.selections(x, deselections = FALSE)
}
\arguments{
\item{x}{vector of binary data (with possible values \code{0} or \code{1})}

\item{deselections}{set to \code{TRUE} if purpose is to count the number of deselections}
}
\value{
count of selections (or deselections if \code{deselections = TRUE})
}
\description{
Count the number of times that the attribute was selected (or optionally: deselected) in a single TCATA or TDS evaluation.
}
\details{
Count the number of times that the attribute was selected (or, optionally, deselected) in a single TCATA or TDS evaluation.
}
\examples{
data(bars)
paste0(bars[1, -c(1:4)], collapse = "")
# this attribute was checked 3 times and unchecked 2 times
count.selections(bars[1, -c(1:4)])
count.selections(bars[1, -c(1:4)], deselections = TRUE)
}
