% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcata.R
\encoding{UTF-8}
\name{fill.gaps}
\alias{fill.gaps}
\title{Fills gaps}
\usage{
fill.gaps(y, subst = 0, repl = 1)
}
\arguments{
\item{y}{vector (or data frame) of Bernoulli data which may contain gaps}

\item{subst}{value occurring in a gap (which represents real data outside a gap). Default is \code{0}.}

\item{repl}{value occurring for a response (used to replace gap values). Default is \code{1}.}
}
\value{
out vector (or data frame) of Bernoulli data with filled gaps
}
\description{
Replace gaps in TDS and TCATA data with replacement responses.
}
\examples{
# vector with gaps: x with NA gaps (e.g. due to attribute cuing)
(x <- rep(c(rep(NA,4), rep(1,4)), 2))
fill.gaps(x, subst = NA)

# array with gaps: y with an gap of 0s (e.g. due to attribute fading)
(y <- structure(c(0, 1, 0,
                  0, 1, 1,
                  0, 1, 1,
                  1, 1, 1,
                  1, 1, 0,
                  1, 1, 0,
                  1, 1, 0,
                  1, 0, 1,
                  1, 0, 1,
                  1, 0, 0),
                .Dim = c(3L, 10L),
                .Dimnames = list(1:3, 1:10)))
fill.gaps(y)
}

