% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hoff_functions.R
\name{rwish}
\alias{rwish}
\title{Wishart simulation.}
\usage{
rwish(S0, nu = dim(as.matrix(S0))[1] + 1)
}
\arguments{
\item{S0}{a positive definite matrix.}

\item{nu}{a positive scalar.}
}
\description{
Simulate a Wishart-distributed random matrix.
}
\details{
This function simulates a Wishart random matrix using Bartletts
decomposition, as described in Everson and Morris (2000).
}
\examples{
# simulate several matrices and compute the mean.
SS <- matrix(0, 5, 5)
for(s in 1:1000) { SS <- SS + tensr:::rwish(diag(5), 3) }
SS / s
}
\author{
Peter Hoff.
}
\keyword{multivariate}
\keyword{simulation}

