% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equi_mcmc.R
\name{sample_sig}
\alias{sample_sig}
\title{Update for total variation parameter in \code{equi_mcmc}.}
\usage{
sample_sig(X, phi_inv)
}
\arguments{
\item{X}{An array. The tensor data.}

\item{phi_inv}{A list of the current values of inverse of the
  lower-triangular Cholesky square root of the the component covariance
  matrices. This is equivalent to the transpose of the upper-triangular
  Cholesky square root of the inverse component covariance matrices.

  \code{phi_inv[[i]]} is a lower triangluar matrix where
  \code{solve(phi_inv[[i]]) \%*\% t(solve(phi_inv[[i]]))} is the current
  estimate of the \eqn{i}th component covariance matrix.}
}
\value{
A numeric. The update for the total variation parameter in the MCMC
  implemented in \code{equi_bayes}.
}
\description{
Samples from the square root of an inverse-gamma.
}
\details{
This function provides a Gibbs update for the total variation parameter from
the MCMC implemented in \code{equi_mcmc}. This corresponds to the square root
of an inverse-gamma distributed random variable whose parameters depend on
the data and the component covariance matrices. Roughly, this is the update
for the standard deviation, not the variance.
}
\author{
David Gerard.
}
\references{
Gerard, D., & Hoff, P. (2015).
  \href{http://www.sciencedirect.com/science/article/pii/S0047259X15000330}{Equivariant
   minimax dominators of the MLE in the array normal model}. \emph{Journal of
  Multivariate Analysis}, 137, 32-49.
}
\seealso{
\code{\link{equi_mcmc}} for a Gibbs sampler where this function is
  used.
}
\keyword{equivariance}

