% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{delete_vertices}
\alias{delete_vertices}
\title{Fast Version of network::delete.vertices for Edgelist-formated Network}
\usage{
delete_vertices(el, vid)
}
\arguments{
\item{el}{A two-column matrix of current edges (edgelist) with an attribute
variable \code{n} containing the total current network size.}

\item{vid}{A vector of IDs to delete from the edgelist.}
}
\value{
Returns a updated edgelist object, \code{el}, with the edges of deleted
vertices removed from the edgelist and the ID numbers of the remaining edges
permuted downward.
}
\description{
Given a current two-column matrix of edges and a vector of IDs
             to delete from the matrix, this function first removes any rows
             of the edgelist in which the IDs are present and then permutes
             downward the index of IDs on the edgelist that were numerically
             larger than the IDs deleted.
}
\details{
This function is used in \code{EpiModel} modules to remove vertices (nodes)
from the edgelist object to account for exits from the population (e.g.,
deaths and out-migration)
}
\examples{
library("EpiModel")
nw <- network.initialize(n = 100, directed = FALSE)
formation <- ~edges
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)
x <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

param <- param.net(inf.prob = 0.3)
init <- init.net(i.num = 10)
control <- control.net(type = "SI", nsteps = 100, nsims = 5, depend = TRUE)

# Set seed for reproducibility
set.seed(123456)

# Full network structure after initialization
dat <- initialize.net(x, param, init, control)

# networkLite representation used by tergmLite
dat <- init_tergmLite(dat)

# Current edges include {1, 87}, {2, 33}, {4, 19}, and {5, 99}
head(dat$el[[1]], 4)

# Remove nodes 1 and 2
nodes.to.delete <- 1:2
dat$el[[1]] <- delete_vertices(dat$el[[1]], nodes.to.delete)

# Old nodes 1 and 2 removed, and old nodes 4 and 5 become nodes 2 and 3
# with edges 19 and 99 also shifted down to 17 and 97
head(dat$el[[1]], 4)

}
