% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_proportion.R
\name{update_weights_strat_wilson}
\alias{update_weights_strat_wilson}
\title{Helper Function for the Estimation of Weights for \code{prop_strat_wilson}}
\usage{
update_weights_strat_wilson(
  vars,
  strata_qnorm,
  initial_weights,
  n_per_strata,
  max_iterations = 50,
  conf_level = 0.95,
  tol = 0.001
)
}
\arguments{
\item{vars}{(\code{numeric})\cr normalized proportions for each strata.}

\item{strata_qnorm}{(\code{numeric})\cr initial estimation with identical weights of the quantiles.}

\item{initial_weights}{(\code{numeric})\cr initial weights used to calculate \code{strata_qnorm}. This can
be optimized in the future if we need to estimate better initial weights.}

\item{n_per_strata}{(\code{numeric})\cr number of elements in each strata.}

\item{max_iterations}{(\code{count})\cr maximum number of iterations to be tried. Convergence is always checked.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{tol}{(\code{number})\cr tolerance threshold for convergence.}
}
\value{
A \code{list} of 3 elements: \code{n_it}, \code{weights}, and \code{diff_v}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function wraps the iteration procedure that allows you to estimate
the weights for each proportional strata. This assumes to minimize the
weighted squared length of the confidence interval.
}
\examples{
vs <- c(0.011, 0.013, 0.012, 0.014, 0.017, 0.018)
sq <- 0.674
ws <- rep(1 / length(vs), length(vs))
ns <- c(22, 18, 17, 17, 14, 12)

update_weights_strat_wilson(vs, sq, ws, ns, 100, 0.95, 0.001)

}
\seealso{
For references and details see \code{\link[=prop_strat_wilson]{prop_strat_wilson()}}.
}
