% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_rtables.R
\name{to_string_matrix}
\alias{to_string_matrix}
\title{Convert table into matrix of strings}
\usage{
to_string_matrix(
  x,
  widths = NULL,
  max_width = NULL,
  hsep = formatters::default_hsep(),
  with_spaces = TRUE,
  print_txt_to_copy = FALSE
)
}
\arguments{
\item{x}{(\code{VTableTree})\cr \code{rtables} table object.}

\item{widths}{(\code{numeric} or  \code{NULL})\cr Proposed widths for the columns of \code{x}. The expected
length of this numeric vector can be retrieved with \code{ncol(x) + 1} as the column of row names
must also be considered.}

\item{max_width}{(\code{integer(1)}, \code{string} or \code{NULL})\cr width that title and footer (including
footnotes) materials should be word-wrapped to. If \code{NULL}, it is set to the current print width of the
session (\code{getOption("width")}). If set to \code{"auto"}, the width of the table (plus any table inset) is
used. Parameter is ignored if \code{tf_wrap = FALSE}.}

\item{hsep}{(\code{string})\cr character to repeat to create header/body separator line. If
\code{NULL}, the object value will be used. If \code{" "}, an empty separator will be printed. See
\code{\link[formatters:default_hsep]{default_hsep()}} for more information.}

\item{with_spaces}{(\code{flag})\cr whether the tested table should keep the indentation and other relevant spaces.}

\item{print_txt_to_copy}{(\code{flag})\cr utility to have a way to copy the input table directly
into the expected variable instead of copying it too manually.}
}
\value{
A \code{matrix} of \code{string}s. If \code{print_txt_to_copy = TRUE} the well formatted printout of the
table will be printed to console, ready to be copied as a expected value.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Helper function to use mostly within tests. \code{with_spaces}parameter allows
to test not only for content but also indentation and table structure.
\code{print_txt_to_copy} instead facilitate the testing development by returning a well
formatted text that needs only to be copied and pasted in the expected output.
}
\examples{
tbl <- basic_table() \%>\%
  split_rows_by("SEX") \%>\%
  split_cols_by("ARM") \%>\%
  analyze("AGE") \%>\%
  build_table(tern_ex_adsl)

to_string_matrix(tbl, widths = ceiling(propose_column_widths(tbl) / 2))

}
