% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskdiff.R
\name{afun_riskdiff}
\alias{afun_riskdiff}
\title{Analysis function to calculate risk difference column values}
\usage{
afun_riskdiff(
  df,
  labelstr = "",
  afun,
  ...,
  .stats = NULL,
  .stat_names = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{labelstr}{(\code{string})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}

\item{afun}{(named \code{list})\cr a named list containing one name-value pair where the name corresponds to
the name of the statistics function that should be used in calculations and the value is the corresponding
analysis function.}

\item{...}{additional arguments for the lower level functions.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.stat_names}{(\code{character})\cr names of the statistics that are passed directly to name single statistics
(\code{.stats}). This option is visible when producing \code{\link[rtables:data.frame_export]{rtables::as_result_df()}} with \code{make_ard = TRUE}.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}
}
\value{
A list of formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
\description{
In the risk difference column, this function uses the statistics function associated with \code{afun} to
calculates risk difference values from arm X (reference group) and arm Y. These arms are specified
when configuring the risk difference column which is done using the \code{\link[=add_riskdiff]{add_riskdiff()}} split function in
the previous call to \code{\link[rtables:split_cols_by]{rtables::split_cols_by()}}. For all other columns, applies \code{afun} as usual. This
function utilizes the \code{\link[=stat_propdiff_ci]{stat_propdiff_ci()}} function to perform risk difference calculations.
}
\seealso{
\itemize{
\item \code{\link[=stat_propdiff_ci]{stat_propdiff_ci()}} for details on risk difference calculation.
\item Split function \code{\link[=add_riskdiff]{add_riskdiff()}} which, when used as \code{split_fun} within \code{\link[rtables:split_cols_by]{rtables::split_cols_by()}} with
\code{riskdiff} argument set to \code{TRUE} in subsequent analyze functions calls, adds a risk difference column
to a table layout.
}
}
\keyword{internal}
