% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voronoi.R
\name{plotBoundedCell2D}
\alias{plotBoundedCell2D}
\title{Plot a bounded Voronoï 2D cell}
\usage{
plotBoundedCell2D(
  cell,
  border = "black",
  color = NA,
  check.bounded = TRUE,
  ...
)
}
\arguments{
\item{cell}{a bounded Voronoï 2D cell}

\item{border}{color of the borders of the cell; \code{NA} for no color}

\item{color}{color of the cell; \code{NA} for no color}

\item{check.bounded}{Boolean, whether to check that the cell is bounded;
set to \code{FALSE} for a small speed gain if you know that the cell is
bounded}

\item{...}{graphical parameters for the borders}
}
\value{
No value, this function just plots the cell (more precisely, it adds
  the plot of the cell to the current plot).
}
\description{
Plot a bounded Voronoï 2D cell.
}
\examples{
library(tessellation)
centricSquare <- rbind(
  c(-1, 1), c(1, 1), c(1, -1), c(-1, -1), c(0, 0)
)
d <- delaunay(centricSquare)
v <- voronoi(d)
cell5 <- v[[5]]
isBoundedCell(cell5) # TRUE
plot(centricSquare, type = "n", asp = 1, xlab = "x", ylab = "y")
plotBoundedCell2D(cell5, color = "pink")
}
