% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Edges.R
\name{Edge2}
\alias{Edge2}
\title{R6 class representing an edge in dimension 2.}
\description{
An edge is given by two vertices in the 2D space,
  named \code{A} and \code{B}. This is for example an edge of a Voronoï cell
  of a 2D Delaunay tessellation.
}
\examples{

## ------------------------------------------------
## Method `Edge2$new`
## ------------------------------------------------

edge <- Edge2$new(c(1, 1), c(2, 3))
edge
edge$A
edge$A <- c(1, 0)
edge

## ------------------------------------------------
## Method `Edge2$print`
## ------------------------------------------------

Edge2$new(c(2, 0), c(3, -1))

## ------------------------------------------------
## Method `Edge2$plot`
## ------------------------------------------------

library(tessellation)
centricSquare <- rbind(
  c(-1, 1), c(1, 1), c(1, -1), c(-1, -1), c(0, 0)
)
d <- delaunay(centricSquare)
v <- voronoi(d)
cell5 <- v[[5]] # the cell of the point (0, 0), at the center
isBoundedCell(cell5) # TRUE
plot(centricSquare, type = "n")
invisible(lapply(cell5[["cell"]], function(edge) edge$plot()))
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{A}}{get or set the vertex \code{A}}

\item{\code{B}}{get or set the vertex \code{B}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Edge2-new}{\code{Edge2$new()}}
\item \href{#method-Edge2-print}{\code{Edge2$print()}}
\item \href{#method-Edge2-plot}{\code{Edge2$plot()}}
\item \href{#method-Edge2-stack}{\code{Edge2$stack()}}
\item \href{#method-Edge2-clone}{\code{Edge2$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Edge2-new"></a>}}
\if{latex}{\out{\hypertarget{method-Edge2-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Edge2} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Edge2$new(A, B)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{A}}{the vertex \code{A}}

\item{\code{B}}{the vertex \code{B}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Edge2} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{edge <- Edge2$new(c(1, 1), c(2, 3))
edge
edge$A
edge$A <- c(1, 0)
edge
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Edge2-print"></a>}}
\if{latex}{\out{\hypertarget{method-Edge2-print}{}}}
\subsection{Method \code{print()}}{
Show instance of an \code{Edge2} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Edge2$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Edge2$new(c(2, 0), c(3, -1))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Edge2-plot"></a>}}
\if{latex}{\out{\hypertarget{method-Edge2-plot}{}}}
\subsection{Method \code{plot()}}{
Plot an \code{Edge2} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Edge2$plot(color = "black", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color}}{the color of the edge}

\item{\code{...}}{graphical parameters such as \code{lty} or \code{lwd}}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(tessellation)
centricSquare <- rbind(
  c(-1, 1), c(1, 1), c(1, -1), c(-1, -1), c(0, 0)
)
d <- delaunay(centricSquare)
v <- voronoi(d)
cell5 <- v[[5]] # the cell of the point (0, 0), at the center
isBoundedCell(cell5) # TRUE
plot(centricSquare, type = "n")
invisible(lapply(cell5[["cell"]], function(edge) edge$plot()))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Edge2-stack"></a>}}
\if{latex}{\out{\hypertarget{method-Edge2-stack}{}}}
\subsection{Method \code{stack()}}{
Stack the two vertices of the edge (this is for internal
purpose).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Edge2$stack()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Edge2-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Edge2-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Edge2$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
